/*******************************************************************************

   Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

 *******************************************************************************

   $Id:: DevNetFal_Public.h 60076 2016-03-21 13:15:05Z trieu                   $

   Description:
    ............................................................................

    Includes following functions:

   Changes:

     Version     Date        Author
     X.X.X.X   DD.MM.JJJJ  Mustermann
     Description................................................................
     ---------------------------------------------------------------------------
     1.1       26.07.07    MK
     - New commands DEVNET_FAL_CMD_AP_REGISTER_REQ / DEVNET_FAL_CMD_FAULT_IND
     1.0       15.03.07    MK
*******************************************************************************/

#ifndef __DEVNET_FAL_PUBLIC_H__
#define __DEVNET_FAL_PUBLIC_H__

/**
* THESE ARE COMPONENTS OF THE HEADER FILE DEVNETFAL_PUBLIC.H
* ============================================================
* @file DEVNETFAL_PUBLIC.H
*/

/*! Maximal data load load size of a packet. Copy of RCX_MAX_DATA_SIZE*/
#define DN_FAL_MAX_DATA_SIZE                                              1556

//STUB Mantis 2681
#define TLR_E_DEVNET_FAL_UPLOAD_INVALID_AREA_CODE                   (0xC0470039)

/**
 * @defgroup Packet_Command PACKET COMMAND DEFINITIONS
 * @{
 * Commands used specifically in DeviceNet Master Stack.
 */

/*!Command code start with this */
#define DEVNET_FAL_CMD_RANGE_START                                  (0x00003800)

/*!Command used to initialize or re-intialize stack #DN_FAL_PACKET_INIT_REQ_T */
#define DEVNET_FAL_CMD_INIT_REQ                                     (0x00003800)

/*!Command received after #DEVNET_FAL_CMD_INIT_REQ, #DN_FAL_PACKET_INIT_CNF_T */
#define DEVNET_FAL_CMD_INIT_CNF                                     (0x00003801)

/*!Download parameter request #DN_FAL_PACKET_DOWNLOAD_REQ_T */
#define DEVNET_FAL_CMD_DOWNLOAD_REQ                                 (0x00003802)

/*!Confirmation of #DEVNET_FAL_CMD_DOWNLOAD_REQ, #DN_FAL_PACKET_DOWNLOAD_CNF_T*/
#define DEVNET_FAL_CMD_DOWNLOAD_CNF                                 (0x00003803)

/*!Command used to set operation mode #DN_FAL_PACKET_SET_MODE_REQ_T           */
#define DEVNET_FAL_CMD_SET_MODE_REQ                                 (0x00003804)

/*!Confirmation received after setting mode #DN_FAL_PACKET_SET_MODE_CNF_T     */
#define DEVNET_FAL_CMD_SET_MODE_CNF                                 (0x00003805)

/*!Command used to clear configuration #DN_FAL_PACKET_CLEAR_CONFIG_REQ_T      */
#define DEVNET_FAL_CMD_CLR_CONFIG_REQ                               (0x00003806)

/*!Confirm of #DEVNET_FAL_CMD_CLR_CONFIG_REQ,#DN_FAL_PACKET_CLEAR_CONFIG_CNF_T*/
#define DEVNET_FAL_CMD_CLR_CONFIG_CNF                               (0x00003807)

/*!Indicate new-comming data #DN_FAL_PACKET_NEW_OUTPUT_IND_T                  */
#define DEVNET_FAL_CMD_NEW_OUTPUT_IND                               (0x00003808)

/*!Response to #DEVNET_FAL_CMD_NEW_OUTPUT_IND, #DN_FAL_PACKET_NEW_OUTPUT_RES_T*/
#define DEVNET_FAL_CMD_NEW_OUTPUT_RES                               (0x00003809)

/*!Command used to get slave attribute, #DN_FAL_PACKET_GETSET_ATT_REQ_T       */
#define DEVNET_FAL_CMD_GET_ATT_REQ                                  (0x0000380A)

/*!Confirmation of #DEVNET_FAL_CMD_GET_ATT_REQ,#DN_FAL_PACKET_GETSET_ATT_CNF_T*/
#define DEVNET_FAL_CMD_GET_ATT_CNF                                  (0x0000380B)

/*!Command used to set slave attribute, #DN_FAL_PACKET_GETSET_ATT_REQ_T       */
#define DEVNET_FAL_CMD_SET_ATT_REQ                                  (0x0000380C)

/*!Confirmation of #DEVNET_FAL_CMD_SET_ATT_REQ,#DN_FAL_PACKET_GETSET_ATT_CNF_T*/
#define DEVNET_FAL_CMD_SET_ATT_CNF                                  (0x0000380D)

/*!Command used to register application task, #DN_FAL_PACKET_AP_REGISTER_REQ_T*/
#define DEVNET_FAL_CMD_AP_REGISTER_REQ                              (0x0000380E)

/*!Confirm of #DEVNET_FAL_CMD_AP_REGISTER_REQ,#DN_FAL_PACKET_AP_REGISTER_CNF_T*/
#define DEVNET_FAL_CMD_AP_REGISTER_CNF                              (0x0000380F)

/*!Fault indication from this task, #DN_FAL_PACKET_FAULT_IND_T                */
#define DEVNET_FAL_CMD_FAULT_IND                                    (0x00003810)

/*!Response for #DEVNET_FAL_CMD_FAULT_IND, #DN_FAL_PACKET_FAULT_RES_T         */
#define DEVNET_FAL_CMD_FAULT_RES                                    (0x00003811)

/*!Command used to bit-strobe slaves, #DN_FAL_PACKET_BTS_REQ_T                */
#define DEVNET_FAL_CMD_ACYC_BTS_REQ                                 (0x00003812)

/*!Confirmation of #DEVNET_FAL_CMD_ACYC_BTS_REQ, #DN_FAL_PACKET_BTS_CNF_T     */
#define DEVNET_FAL_CMD_ACYC_BTS_CNF                                 (0x00003813)

/*!Lifelist (available slaves on bus) request. #DN_FAL_PACKET_LIFELIST_REQ_T  */
#define DEVNET_FAL_CMD_LIFELIST_REQ                                 (0x00003814)

/*! Confirmation of #DEVNET_FAL_CMD_LIFELIST_REQ. #DN_FAL_LIFELIST_CNF_T      */
#define DEVNET_FAL_CMD_LIFELIST_CNF                                 (0x00003815)

/*! Device, Bus, Or Slave Parameters Upload, #DN_FAL_PACKET_UPLOAD_REQ_T      */
#define DEVNET_FAL_CMD_UPLOAD_REQ                                   (0x00003816)

/*! Confirmation of #DEVNET_FAL_CMD_UPLOAD_REQ. #DN_FAL_PACKET_UPLOAD_CNF_T   */
#define DEVNET_FAL_CMD_UPLOAD_CNF                                   (0x00003817)

/*! Indication of mode changed #DN_FAL_PACKET_SET_MODE_IND_T                     */
#define DEVNET_FAL_CMD_SET_MODE_IND                                 (0x00003818)

/*! Response of #DEVNET_FAL_CMD_SET_MODE_IND, #DN_FAL_SDU_SET_MODE_RES_T      */
#define DEVNET_FAL_CMD_SET_MODE_RES                                 (0x00003819)

/*! Request diagnose of the slave, #DN_FAL_PACKET_DEV_DIAG_REQ_T              */
#define DEVNET_FAL_CMD_DEV_DIAG_REQ                                 (0x00003820)

/*!Confirmation of #DEVNET_FAL_CMD_DEV_DIAG_REQ, #DN_FAL_PACKET_DEV_DIAG_CNF_T*/
#define DEVNET_FAL_CMD_DEV_DIAG_CNF                                 (0x00003821)

/*!Send service request to remote slave, #DN_FAL_PACKET_SERVICE_REQ_T         */
#define DEVNET_FAL_CMD_REMOTE_SERVICE_REQ                           (0x00003822)

/*!Confirm of #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ, #DN_FAL_PACKET_SERVICE_CNF_T*/
#define DEVNET_FAL_CMD_REMOTE_SERVICE_CNF                           (0x00003823)

/*!Send service request to master itself, #DN_FAL_PACKET_SERVICE_REQ_T        */
#define DEVNET_FAL_CMD_LOCAL_SERVICE_REQ                            (0x00003824)

/*!Confirm of #DEVNET_FAL_CMD_LOCAL_SERVICE_REQ, #DN_FAL_PACKET_SERVICE_CNF_T */
#define DEVNET_FAL_CMD_LOCAL_SERVICE_CNF                            (0x00003825)

/*!End of Routed DeviceNet Master Packet Command Range                        */
#define DEVNET_FAL_CMD_RANGE_END                                    (0x00003825)

/*!Get Attribute All Request. NOT USED                                        */
#define DEVNET_FAL_CMD_GET_ATT_ALL_REQ                              (0x0000381A)

/*!Get Attribute All Confirm. NOT USED                                        */
#define DEVNET_FAL_CMD_GET_ATT_ALL_CNF                              (0x0000381B)

/*!Send poll request to slave at anytime, #DN_FAL_PACKET_ACYC_IO_POLL_REQ_T   */
#define DEVNET_FAL_CMD_ACYC_POLL_REQ                                (0x000038E0)

/*!Confirm of #DEVNET_FAL_CMD_ACYC_POLL_REQ, #DN_FAL_PACKET_ACYC_IO_POLL_CNF_T*/
#define DEVNET_FAL_CMD_ACYC_POLL_CNF                                (0x000038E1)

/*!Register a CANID forwarded to application, #DN_FAL_PACKET_CAN_FWD_REG_REQ_T */
#define DEVNET_FAL_CMD_CAN_FWD_REG_REQ                              (0x000038E2)

/*!Confirm of #DEVNET_FAL_CMD_CAN_FWD_REG_REQ,#DN_FAL_PACKET_CAN_FWD_REG_CNF_T*/
#define DEVNET_FAL_CMD_CAN_FWD_REG_CNF                              (0x000038E3)

/*!Indication that a CAN message is forwarded, #DN_FAL_PACKET_CAN_FWD_IND_T   */
#define DEVNET_FAL_CMD_CAN_FWD_IND                                  (0x000038E4)

/*!Response to #DEVNET_FAL_CMD_CAN_FWD_IND, #DN_FAL_PACKET_CAN_FWD_RES_T      */
#define DEVNET_FAL_CMD_CAN_FWD_RES                                  (0x000038E5)

/*!Request sending of CAN frame on bus, #DN_FAL_PACKET_CAN_DATA_REQ_T         */
#define DEVNET_FAL_CMD_CAN_DATA_REQ                                 (0x000038E6)

/*!Confirmation of #DEVNET_FAL_CMD_CAN_DATA_REQ, #DN_FAL_PACKET_CAN_DATA_CNF_T*/
#define DEVNET_FAL_CMD_CAN_DATA_CNF                                 (0x000038E7)

/*!Set LED indication. #DN_FAL_PACKET_SET_LED_IND_T                           */
#define DEVNET_FAL_CMD_SET_LED_IND                                  (0x000038E8)

/*!Response of #DEVNET_FAL_CMD_SET_LED_IND,  #DN_FAL_PACKET_SET_LED_RES_T     */
#define DEVNET_FAL_CMD_SET_LED_RES                                  (0x000038E9)

#define DNM_CMD_RANGE_START                    DEVNET_FAL_CMD_RANGE_START
#define DNM_CMD_INIT_REQ                       DEVNET_FAL_CMD_INIT_REQ
#define DNM_CMD_INIT_CNF                       DEVNET_FAL_CMD_INIT_CNF
#define DNM_CMD_DOWNLOAD_REQ                   DEVNET_FAL_CMD_DOWNLOAD_REQ
#define DNM_CMD_DOWNLOAD_CNF                   DEVNET_FAL_CMD_DOWNLOAD_CNF
#define DNM_CMD_SET_MODE_REQ                   DEVNET_FAL_CMD_SET_MODE_REQ
#define DNM_CMD_SET_MODE_CNF                   DEVNET_FAL_CMD_SET_MODE_CNF
#define DNM_CMD_CLR_CONFIG_REQ                 DEVNET_FAL_CMD_CLR_CONFIG_REQ
#define DNM_CMD_CLR_CONFIG_CNF                 DEVNET_FAL_CMD_CLR_CONFIG_CNF
#define DNM_CMD_NEW_OUTPUT_IND                 DEVNET_FAL_CMD_NEW_OUTPUT_IND
#define DNM_CMD_NEW_OUTPUT_RES                 DEVNET_FAL_CMD_NEW_OUTPUT_RES
#define DNM_CMD_GET_ATT_REQ                    DEVNET_FAL_CMD_GET_ATT_REQ
#define DNM_CMD_GET_ATT_CNF                    DEVNET_FAL_CMD_GET_ATT_CNF
#define DNM_CMD_SET_ATT_REQ                    DEVNET_FAL_CMD_SET_ATT_REQ
#define DNM_CMD_SET_ATT_CNF                    DEVNET_FAL_CMD_SET_ATT_CNF
#define DNM_CMD_AP_REGISTER_REQ                DEVNET_FAL_CMD_AP_REGISTER_REQ
#define DNM_CMD_AP_REGISTER_CNF                DEVNET_FAL_CMD_AP_REGISTER_CNF
#define DNM_CMD_FAULT_IND                      DEVNET_FAL_CMD_FAULT_IND
#define DNM_CMD_FAULT_RES                      DEVNET_FAL_CMD_FAULT_RES
#define DNM_CMD_ACYC_BTS_REQ                   DEVNET_FAL_CMD_ACYC_BTS_REQ
#define DNM_CMD_ACYC_BTS_CNF                   DEVNET_FAL_CMD_ACYC_BTS_CNF

#define DNM_CMD_LIFELIST_REQ                   DEVNET_FAL_CMD_LIFELIST_REQ
#define DNM_CMD_LIFELIST_CNF                   DEVNET_FAL_CMD_LIFELIST_CNF

#define DNM_CMD_UPLOAD_REQ                     DEVNET_FAL_CMD_UPLOAD_REQ
#define DNM_CMD_UPLOAD_CNF                     DEVNET_FAL_CMD_UPLOAD_CNF

#define DNM_CMD_SET_MODE_IND                   DEVNET_FAL_CMD_SET_MODE_IND
#define DNM_CMD_SET_MODE_RES                   DEVNET_FAL_CMD_SET_MODE_RES

#define DNM_CMD_DEV_DIAG_REQ                   DEVNET_FAL_CMD_DEV_DIAG_REQ
#define DNM_CMD_DEV_DIAG_CNF                   DEVNET_FAL_CMD_DEV_DIAG_CNF

#define DNM_CMD_REMOTE_SERVICE_REQ             DEVNET_FAL_CMD_REMOTE_SERVICE_REQ
#define DNM_CMD_REMOTE_SERVICE_CNF             DEVNET_FAL_CMD_REMOTE_SERVICE_CNF

#define DNM_CMD_LOCAL_SERVICE_REQ              DEVNET_FAL_CMD_LOCAL_SERVICE_REQ
#define DNM_CMD_LOCAL_SERVICE_CNF              DEVNET_FAL_CMD_LOCAL_SERVICE_CNF

#define DNM_CMD_RANGE_END                      DEVNET_FAL_CMD_RANGE_END

#define DNM_CMD_GET_ATT_ALL_REQ                DEVNET_FAL_CMD_GET_ATT_ALL_REQ
#define DNM_CMD_GET_ATT_ALL_CNF                DEVNET_FAL_CMD_GET_ATT_ALL_CNF

#define DNM_CMD_ACYC_POLL_REQ                  DEVNET_FAL_CMD_ACYC_POLL_REQ
#define DNM_CMD_ACYC_POLL_CNF                  DEVNET_FAL_CMD_ACYC_POLL_CNF

#define DNM_CMD_CAN_FWD_REG_REQ                DEVNET_FAL_CMD_CAN_FWD_REG_REQ
#define DNM_CMD_CAN_FWD_REG_CNF                DEVNET_FAL_CMD_CAN_FWD_REG_CNF

#define DNM_CMD_CAN_FWD_IND                    DEVNET_FAL_CMD_CAN_FWD_IND
#define DNM_CMD_CAN_FWD_RES                    DEVNET_FAL_CMD_CAN_FWD_RES

#define DNM_CMD_CAN_DATA_REQ                   DEVNET_FAL_CMD_CAN_DATA_REQ
#define DNM_CMD_CAN_DATA_CNF                   DEVNET_FAL_CMD_CAN_DATA_CNF

#define DNM_FAL_CMD_SET_LED_IND                DEVNET_FAL_CMD_SET_LED_IND
#define DNM_FAL_CMD_SET_LED_RES                DEVNET_FAL_CMD_SET_LED_RES
/**
 * @}
 */


/**
 * @defgroup CIP_Service_Code COMMON CIP SERVICE CODE
 * @{
 * Common service ODVA CIP service code
 */
/*                                                     */
//#define served for future use                                           00 n/a
/*! Get_Attributes_All. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_GET_ATTRIBUTES_ALL                                  0x01

/*! Set_Attributes_All. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_SET_ATTRIBUTES_ALL                                  0x02

/*! Get_Attribute_List. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_GET_ATTRIBUTE_LIST                                  0x03

/*! Set_Attribute_List. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_SET_ATTRIBUTE_LIST                                  0x04

/*! Reset. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_RESET                                               0x05

/*! Start. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_START                                               0x06

/*! Stop. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_STOP                                                0x07

/*! Create. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_CREATE                                              0x08

/*! Delete. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_DELETE                                              0x09

/*! Multiple_Service_Packet. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_MULTIPLE_SERVICE_PACKET                             0x0A


//#define DEVNEP_SRV_CODE_RESERVED FOR FUTURE USE                      0x  0B-0C

/*! Apply_Attributes. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_APPLY_ATTRIBUTES                                    0x0D

/*! Get_Attribute_Single. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_GET_ATTRIBUTE_SINGLE                                0x0E


//#define DEVNET_SRV_CODE_SERVED FOR FUTURE USE                             0x0F

/*! Set_Attribute_Single. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_SET_ATTRIBUTE_SINGLE                                0x10

/*! Find_Next_Object_Instance. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_FIND_NEXT_OBJECT_INSTANCE                           0x11


//#define DEVNEP_SRV_CODE_RESERVED FOR FUTURE USE                      0x12 - 13

/*!Error Response (used by DeviceNet only). #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ*/
#define DEVNET_SRV_CODE_ROR_RESPONSE /*USED BY DEVICENET ONLY*/             0x14

/*! Restore. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_RESTORE                                             0x15

/*! Save. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_SAVE                                                0x16

/*! No Operation (NOP). #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_NO_OPERATION                                        0x17

/*! Get_Member. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_GET_MEMBER                                          0x18

/*! Set_Member. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_SET_MEMBER                                          0x19

/*! Insert_Member. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_INSERT_MEMBER                                       0x1A

/*! Remove_Member. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_REMOVE_MEMBER                                       0x1B

/*! GroupSync. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_GROUPSYNC                                           0x1C


//#define DEVNET_CIP_SRV_CODE_RESERVED FOR ADDITIONAL COMMON SERVICES      1D-31

/*! Alloc master slave connection. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_ALLOC_MST_SLV_CNXN                                  0x4B

/*! Release master slave connection. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_RELEASE_MST_SLV_CNXN                                0x4C

/*! Open explicit connection. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_OPEN_EXZ_CNXN                                       0x4B

/*! Close explicit connection. #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ */
#define DEVNET_SRV_CODE_CLOSE_EXZ_CNXN                                      0x4C

/* COMMON CIP SERVICE CODE                                                    */
//#define served for future use                                    00 n/a
#define DNM_CIP_SRV_GET_ATTRIBUTES_ALL   DEVNET_SRV_CODE_GET_ATTRIBUTES_ALL
#define DNM_CIP_SRV_SET_ATTRIBUTES_ALL   DEVNET_SRV_CODE_SET_ATTRIBUTES_ALL
#define DNM_CIP_SRV_GET_ATTRIBUTE_LIST   DEVNET_SRV_CODE_GET_ATTRIBUTE_LIST
#define DNM_CIP_SRV_SET_ATTRIBUTE_LIST   DEVNET_SRV_CODE_SET_ATTRIBUTE_LIST
#define DNM_CIP_SRV_RESET                DEVNET_SRV_CODE_RESET
#define DNM_CIP_SRV_START                DEVNET_SRV_CODE_START
#define DNM_CIP_SRV_STOP                 DEVNET_SRV_CODE_STOP
#define DNM_CIP_SRV_CREATE               DEVNET_SRV_CODE_CREATE
#define DNM_CIP_SRV_DELETE               DEVNET_SRV_CODE_DELETE
#define DNM_CIP_SRV_MULTIPLE_SRV_PACKET  DEVNET_SRV_CODE_MULTIPLE_SERVICE_PACKET
//#define DEVNEP_SRV_CODE_RESERVED FOR FUTURE USE                  0x  0B-0C
#define DNM_CIP_SRV_APPLY_ATTRIBUTES     DEVNET_SRV_CODE_APPLY_ATTRIBUTES
#define DNM_CIP_SRV_GET_ATTRIBUTE_SINGLE DEVNET_SRV_CODE_GET_ATTRIBUTE_SINGLE
//#define DEVNET_SRV_CODE_SERVED FOR FUTURE USE                      0x0F
#define DNM_CIP_SRV_SET_ATTRIBUTE_SINGLE DEVNET_SRV_CODE_SET_ATTRIBUTE_SINGLE
#define DNM_CIP_SRV_FIND_NEXT_OBJ_INST DEVNET_SRV_CODE_FIND_NEXT_OBJECT_INSTANCE
//#define DEVNEP_SRV_CODE_RESERVED FOR FUTURE USE                  0x12 - 13
#define DNM_CIP_SRV_ROR_RESPONSE         DEVNET_SRV_CODE_ROR_RESPONSE
#define DNM_CIP_SRV_RESTORE              DEVNET_SRV_CODE_RESTORE
#define DNM_CIP_SRV_SAVE                 DEVNET_SRV_CODE_SAVE
#define DNM_CIP_SRV_NO_OPERATION         DEVNET_SRV_CODE_NO_OPERATION
#define DNM_CIP_SRV_GET_MEMBER           DEVNET_SRV_CODE_GET_MEMBER
#define DNM_CIP_SRV_SET_MEMBER           DEVNET_SRV_CODE_SET_MEMBER
#define DNM_CIP_SRV_INSERT_MEMBER        DEVNET_SRV_CODE_INSERT_MEMBER
#define DNM_CIP_SRV_REMOVE_MEMBER        DEVNET_SRV_CODE_REMOVE_MEMBER
#define DNM_CIP_SRV_GROUPSYNC            DEVNET_SRV_CODE_GROUPSYNC
//#define DEVNET_CIP_SRV_CODE_RESERVED FOR ADDITIONAL COMMON SERVICES   1D-31
#define DNM_CIP_SRV_ALLOC_MST_SLV_CNXN   DEVNET_SRV_CODE_ALLOC_MST_SLV_CNXN
#define DNM_CIP_SRV_RELEASE_MST_SLV_CNXN DEVNET_SRV_CODE_RELEASE_MST_SLV_CNXN
#define DNM_CIP_SRV_OPEN_EXZ_CNXN        DEVNET_SRV_CODE_OPEN_EXZ_CNXN
#define DNM_CIP_SRV_CLOSE_EXZ_CNXN       DEVNET_SRV_CODE_CLOSE_EXZ_CNXN
/**
 * @}
 */

/**
 * @defgroup CIP_Class_Code COMMON CIP CLASS ID CODE
 * @{
 * Common ODVA CIP class id code. @see ::DN_FAL_SDU_SERVICE_REQ_Ttag::usClass
 */

/******************************************************************************/
/*                             COMMON CIP CLASS                               */
/******************************************************************************/
#define DNM_CIP_CLASS_IDENTITY                                              0x01
#define DNM_CIP_CLASS_MESSAGE_ROUTER                                        0x02
#define DNM_CIP_CLASS_DEVICENET                                             0x03
#define DNM_CIP_CLASS_ASSEMBLY                                              0x04
#define DNM_CIP_CLASS_CONNECTION                                            0x05
#define DNM_CIP_CLASS_CONNECTION_MANAGER                                    0x06
#define DNM_CIP_CLASS_REGISTER                                              0x07
#define DNM_CIP_CLASS_DISCRETE_INPUT_POINT                                  0x08
#define DNM_CIP_CLASS_DISCRETE_OUTPUT_POINT                                 0x09
#define DNM_CIP_CLASS_ANALOG_INPUT_POINT                                    0x0A
#define DNM_CIP_CLASS_ANALOG_OUTPUT_POINT                                   0x0B
#define DNM_CIP_CLASS_PRESENCE_SENSING                                      0x0E
#define DNM_CIP_CLASS_PARAMETER                                             0x0F
#define DNM_CIP_CLASS_PARAMETER_GROUP                                       0x10
#define DNM_CIP_CLASS_GROUP                                                 0x12
#define DNM_CIP_CLASS_DISCRETE_INPUT_GROUP                                  0x1D
#define DNM_CIP_CLASS_DISCRETE_OUTPUT_GROUP                                 0x1E
#define DNM_CIP_CLASS_DISCRETE_GROUP                                        0x1F
#define DNM_CIP_CLASS_ANALOG_INPUT_GROUP                                    0x20
#define DNM_CIP_CLASS_ANALOG_OUTPUT_GROUP                                   0x21
#define DNM_CIP_CLASS_ANALOG_GROUP                                          0x22
#define DNM_CIP_CLASS_POSITION_SENSOR                                       0x23
#define DNM_CIP_CLASS_POSITION_CONTROLLER_SUPERVISOR                        0x24
#define DNM_CIP_CLASS_POSITION_CONTROLLER                                   0x25
#define DNM_CIP_CLASS_BLOCK_SEQUENCER                                       0x26
#define DNM_CIP_CLASS_COMMAND_BLOCK                                         0x27
#define DNM_CIP_CLASS_MOTOR_DATA                                            0x28
#define DNM_CIP_CLASS_CONTROL_SUPERVISOR                                    0x29
#define DNM_CIP_CLASS_AC_DC_DRIVE                                           0x2A
#define DNM_CIP_CLASS_ACKNOWLEDGE_HANDLER                                   0x2B
#define DNM_CIP_CLASS_OVERLOAD_OBJECT                                       0x2C
#define DNM_CIP_CLASS_SOFTSTART                                             0x2D
#define DNM_CIP_CLASS_SELECTION                                             0x2E
#define DNM_CIP_CLASS_S_DEVICE_SUPERVISOR                                   0x30
#define DNM_CIP_CLASS_S_ANALOG_SENSOR                                       0x31
#define DNM_CIP_CLASS_S_ANALOG_ACTUATOR                                     0x32
#define DNM_CIP_CLASS_S_SINGLE_STAGE_CONTROLLER_OBJECT                      0x33
#define DNM_CIP_CLASS_S_GAS_CALIBRATION                                     0x34
#define DNM_CIP_CLASS_TRIP_POINT                                            0x35
#define DNM_CIP_CLASS_N_A_DRIVE_DATA                                        0x36
#define DNM_CIP_CLASS_FILE                                                  0x37
#define DNM_CIP_CLASS_S_PARTIAL_PRESSURE                                    0x38
#define DNM_CIP_CLASS_SAFETY_SUPERVISOR                                     0x39
#define DNM_CIP_CLASS_SAFETY_VALIDATOR                                      0x3A
#define DNM_CIP_CLASS_SAFETY_DISCRETE_OUTPUT_POINT                          0x3B
#define DNM_CIP_CLASS_SAFETY_DISCRETE_OUTPUT_GROUP                          0x3C
#define DNM_CIP_CLASS_SAFETY_DISCRETE_INPUT_POINT                           0x3D
#define DNM_CIP_CLASS_SAFETY_DISCRETE_INPUT_GROUP                           0x3E
#define DNM_CIP_CLASS_SAFETY_DUAL_CHANNEL_OUTPUT                            0x3F
#define DNM_CIP_CLASS_S_SENSOR_CALIBRATION                                  0x40
#define DNM_CIP_CLASS_EVENT_LOG_OBJECT                                      0x41
#define DNM_CIP_CLASS_MOTION_DEVICE_AXIS                                    0x42
#define DNM_CIP_CLASS_TIME_SYNC                                             0x43
#define DNM_CIP_CLASS_MODBUS                                                0x44
#define DNM_CIP_CLASS_ORIGINATOR_CONNECTION_LIST                            0x45
#define DNM_CIP_CLASS_MODBUS_SERIAL_LINK                                    0x46
#define DNM_CIP_CLASS_DEVICE_LEVEL_RING                                     0x47
#define DNM_CIP_CLASS_QOS                                                   0x48
#define DNM_CIP_CLASS_SAFETY_ANALOG_INPUT_POINT                             0x49
#define DNM_CIP_CLASS_SAFETY_ANALOG_INPUT_GROUP                             0x4A
#define DNM_CIP_CLASS_SAFETY_DUAL_CHANNEL_ANALOG_INPUT                      0x4B
#define DNM_CIP_CLASS_SERCOS_III_LINK                                       0x4C
#define DNM_CIP_CLASS_TARGET_CONNECTION_LIST                                0x4D
#define DNM_CIP_CLASS_ENERGY                                                0x4E
#define DNM_CIP_CLASS_ELECTRICAL_ENERGY                                     0x4F
#define DNM_CIP_CLASS_NON_ELECTRICAL_ENERGY                                 0x50
#define DNM_CIP_CLASS_BASE_SWITCH                                           0x51
#define DNM_CIP_CLASS_SNMP                                                  0x52
#define DNM_CIP_CLASS_POWER_MANAGEMENT                                      0x53
#define DNM_CIP_CLASS_RSTP_BRIDGE                                           0x54
#define DNM_CIP_CLASS_RSTP_PORT                                             0x55
#define DNM_CIP_CLASS_CONTROLNET                                            0xF0
#define DNM_CIP_CLASS_CONTROLNET_KEEPER                                     0xF1
#define DNM_CIP_CLASS_CONTROLNET_SCHEDULING                                 0xF2
#define DNM_CIP_CLASS_CONNECTION_CONFIGURATION                              0xF3
#define DNM_CIP_CLASS_PORT                                                  0xF4
#define DNM_CIP_CLASS_TCP_IP_INTERFACE                                      0xF5
#define DNM_CIP_CLASS_ETHERNET_LINK                                         0xF6
#define DNM_CIP_CLASS_COMPONET_LINK                                         0xF7
#define DNM_CIP_CLASS_COMPONET_REPEATER                                     0xF8
/**
 * @}
 */

/**
 * @defgroup CIP_ID_Object_Attribute ATTRIBUTES OF IDENTITY OBJECT
 * @{
 * Common ODVA CIP IDENTITY OBJECT CODE
 */
/******************************************************************************/
/*                             COMMON CIP ATTRIBUTE                           */
/******************************************************************************/
#define DNM_CIP_IDOBJ_VENDOR_ID                                              (1)
#define DNM_CIP_IDOBJ_DEVICE_TYPE                                            (2)
#define DNM_CIP_IDOBJ_PRODUCT_CODE                                           (3)
#define DNM_CIP_IDOBJ_REVISION                                               (4)
#define DNM_CIP_IDOBJ_STATUS                                                 (5)
#define DNM_CIP_IDOBJ_SERIAL                                                 (6)
#define DNM_CIP_IDOBJ_PRODUCT_NAME                                           (7)
#define DNM_CIP_IDOBJ_STATE                                                  (8)
#define DNM_CIP_IDOBJ_CFG_CONSIST_VAL                                        (9)
#define DNM_CIP_IDOBJ_HEARTBEAT                                             (10)
#define DNM_CIP_IDOBJ_ACTIVE_LANG                                           (11)
#define DNM_CIP_IDOBJ_SUPPORTED_LANG                                        (12)
#define DNM_CIP_IDOBJ_INTER_PROD_NAME                                       (13)
#define DNM_CIP_IDOBJ_SEMAPHORE                                             (14)
#define DNM_CIP_IDOBJ_ASSIGNED_NAME                                         (15)
#define DNM_CIP_IDOBJ_ASSIGNED_DESC                                         (16)
#define DNM_CIP_IDOBJ_GEO_LOC                                               (17)
#define DNM_CIP_IDOBJ_MODBUS_ID_INFO                                        (18)
/**
 * @}
 */


/**
 * @defgroup CIP_General_Error_Code GENERAL ERROR CODE
 * @{
 * Common ODVA CIP Class ID Code. @see ::DN_FAL_SDU_SERVICE_CNF_Ttag::bGenErr
 */
/******************************************************************************/
/*                      COMMON CIP GENERAL ERROR CODE                         */
/******************************************************************************/
/*!Service was successfully performed by the object specified.                */
#define DNM_CIP_GEN_E_SUCCESS                                               0x00

/*!A connection related service failed along the connection path.             */
#define DNM_CIP_GEN_E_CONNECTION_FAILURE                                    0x01

/*!Resources needed for the object to perform the service were unavailable    */
#define DNM_CIP_GEN_E_RESOURCE_UNAVAILABLE                                  0x02

/*!See Status Code 0x20,  preferred value to use for this condition           */
#define DNM_CIP_GEN_E_INVALID_PARAMETER_VALUE                               0x03

/*!The path segment identifier or the segment syntax was not understood by the
   processing node. Path processing stops on a path segment error             */
#define DNM_CIP_GEN_E_PATH_SEGMENT_ERROR                                    0x04

/*! The path is referencing an object class, instance or structure element that
 * is not known or is not contained in the processing node. Path processing
 * shall stop when a path destination unknown error is encountered.           */
#define DNM_CIP_GEN_E_PATH_DESTINATION_UNKNOWN                              0x05

/*!Only part of the expected data was transferred.                            */
#define DNM_CIP_GEN_E_PARTIAL_TRANSFER                                      0x06

/*!The messaging connection was lost.                                         */
#define DNM_CIP_GEN_E_CONNECTION_LOST                                       0x07

/*!The requested service was not implemented/defined for this Class/Instance  */
#define DNM_CIP_GEN_E_SERVICE_NOT_SUPPORTED                                 0x08

/*!Invalid attribute data detected                                            */
#define DNM_CIP_GEN_E_INVALID_ATTRIBUTE_VALUE                               0x09

/*!An attribute in the Get/Set_Attribute_List response has a non-zero status  */
#define DNM_CIP_GEN_E_ATTRIBUTE_LIST_ERROR                                  0x0A

/*!The object is already in the mode/state being requested by the service     */
#define DNM_CIP_GEN_E_ALREADY_IN_REQUESTED_STATE                            0x0B

/*!The object cannot perform the requested service in its current mode/state  */
#define DNM_CIP_GEN_E_OBJECT_STATE_CONFLICT                                 0x0C

/*!The requested instance of object to be created already exists              */
#define DNM_CIP_GEN_E_OBJECT_ALREADY_EXISTS                                 0x0D

/*!A request to modify a non-modifiable attribute was received                */
#define DNM_CIP_GEN_E_ATTRIBUTE_NOT_SETTABLE                                0x0E

/*!A permission/privilege check failed                                        */
#define DNM_CIP_GEN_E_PRIVILEGE_VIOLATION                                   0x0F

/*!The devices current mode/state prohibits the execution of the service     */
#define DNM_CIP_GEN_E_DEVICE_STATE_CONFLICT                                 0x10

/*!The data to be transmitted in the response buffer is larger than the
 * allocated response buffer                                                  */
#define DNM_CIP_GEN_E_REPLY_DATA_TOO_LARGE                                  0x11

/*!The service specified an operation that is going to fragment a primitive
 * data value, i.e. half a REAL data type.                                    */
#define DNM_CIP_GEN_E_FRAG_OF_A_PRIMITIVE_VALUE                             0x12

/*!The service did not supply enough data to perform the specified operation. */
#define DNM_CIP_GEN_E_NOT_ENOUGH_DATA                                       0x13

/*!The attribute specified in the request is not supported                    */
#define DNM_CIP_GEN_E_ATTRIBUTE_NOT_SUPPORTED                               0x14

/*!The service supplied more data than was expected                           */
#define DNM_CIP_GEN_E_TOO_MUCH_DATA                                         0x15

/*!The object specified does not exist in the device                          */
#define DNM_CIP_GEN_E_OBJECT_DOES_NOT_EXIST                                 0x16

/*!The frag sequence for this service is not currently active for this data   */
#define DNM_CIP_GEN_E_SRV_FRAG_SEQ_NOT_IN_PROGRESS                          0x17

/*!The attribute data of this object was not saved prior to the service       */
#define DNM_CIP_GEN_E_NO_STORED_ATTRIBUTE_DATA                              0x18

/*! Attr data of this object was not saved due to failure during the attempt  */
#define DNM_CIP_GEN_E_STORE_OPERATION_FAILURE                               0x19

/*!The service request packet was too large for transmission on a network in
 *the path to the destination. The routing dev was forced aborting the service*/
#define DNM_CIP_GEN_E_ROUTING_FAIL_REQ_PCK_TOO_BIG                          0x1A

/*!The service response packet was too large for transmission on a network in
 * the path from the destination. The routing device was forced aborting
 * the service.                                                               */
#define DNM_CIP_GEN_E_ROUTING_FAIL_RES_PCK_TOO_BIG                          0x1B

/*!The service did not supply an attribute in a list of attributes that
 * was needed by the service to perform the requested behavior.               */
#define DNM_CIP_GEN_E_MISSING_ATTR_LIST_ENTRY_DATA                          0x1C

/*!The service is returning the list of attributes supplied with status
   information for those attributes that were invalid                         */
#define DNM_CIP_GEN_E_INVALID_ATTR_VALUE_LIST                               0x1D

/*!An embedded service resulted in an error                                   */
#define DNM_CIP_GEN_E_EMBEDDED_SERVICE_ERROR                                0x1E

/*!A vendor specific error has been encountered. The Additional Code Field of
 * the Error Response defines the particular error encountered. Use of this
 * General Error Code should only be performed when none of the Error Codes
 * presented in this table or within an Object Class definition accurately
 * reflect the error.                                                         */
#define DNM_CIP_GEN_E_VENDOR_SPECIFIC_ERROR                                 0x1F

/*!A parameter associated with the request was invalid. This code is used when
 * a parameter does not meet the requirements of this specification and/or the
 * requirements defined in an Application Object Specification.               */
#define DNM_CIP_GEN_E_INVALID_PARAMETER                                     0x20

/*!An attempt was made to write to a write-once medium (e.g. WORM drive, PROM)
 * that has already been written, or to modify a value that cannot be changed
 * once established.                                                          */
#define DNM_CIP_GEN_E_WRITE_ONCE_VALUE_OR_MEDIUM                            0x21

/*!An invalid reply is received (e.g. reply service code does not match the
 * request service code, or reply message is shorter than the minimum expected
 * reply size). This status code can serve for other causes of invalid replies*/
#define DNM_CIP_GEN_E_INVALID_REPLY_RECEIVED                                0x22

/*!The message received is larger than the receiving buffer can handle.
 * The entire message was discarded                                           */
#define DNM_CIP_GEN_E_BUFFER_OVERFLOW                                       0x23

/*!The format of the received message is not supported by the server          */
#define DNM_CIP_GEN_E_MESSAGE_FORMAT_ERROR                                  0x24

/*!The Key Segment that was included as the first segment in the path does not
 * match the destination module. The object specific status shall indicate
 * which part of the key check failed                                         */
#define DNM_CIP_GEN_E_KEY_FAILURE_IN_PATH                                   0x25

/*!The size of the path which was sent with the Service Request is either not
 * large enough to allow the Request to be routed to an object or too
 * much routing data was included.                                            */
#define DNM_CIP_GEN_E_PATH_SIZE_INVALID                                     0x26

/*!An attempt was made to set an attr that is not able to be set at this time */
#define DNM_CIP_GEN_E_UNEXPECTED_ATTRIBUTE_IN_LIST                          0x27

/*!The Member ID specified in the request does not exist in the specified
 * Class/Instance/Attribute                                                   */
#define DNM_CIP_GEN_E_INVALID_MEMBER_ID                                     0x28

/*!A request to modify a non-modifiable member was received                   */
#define DNM_CIP_GEN_E_MEMBER_NOT_SETTABLE                                   0x29

/*!This error code may only be reported by DeviceNet Group 2 Only servers with
 * 4K or less code space and only in place of Service not supported,
 * Attribute not supported and Attribute not settable                         */
#define DNM_CIP_GEN_E_GROUP_2_ONLY_SERVER_GEN_FAIL                          0x2A

/*!A CIP to Modbus translator received an unknown Modbus Exception Code       */
#define DNM_CIP_GEN_E_UNKNOWN_MODBUS_ERROR                                  0x2B

/*!A request to read a non-readable attribute was received                    */
#define DNM_CIP_GEN_E_ATTRIBUTE_NOT_GETTABLE                                0x2C

//Reserved by CIP for future extensions                               2D - CF //
/* This range of error codes is to be used to indicate Object Class specific
 * errors. Use of this range should only be performed when none of the Error
 * Codes presented in this table accurately reflect the error                 */
//Reserved for Object Class and service errors                           D0 - FF

/**
 * @}
 */

/** DevNet Fal public, constants **********************************************/

/**
 * @defgroup Miscellaneous All others definitions
 * @{
 * All others definitions
 */
/*! Process queue name */
#define DEVNET_FAL_PROCESS_QUEUE_NAME                           "DEVNET_FAL_QUE"
/**
 * @}
 */

/**
 * @defgroup Baudrate Baudrate of the DeviceNet Network
 * @{
 * DeviceNet Baudrate
 */
/*! Baudrate 500k */
#define DN_FAL_BAUDRATE_500                                                  (1)
/*! Baudrate 250k */
#define DN_FAL_BAUDRATE_250                                                  (2)
/*! Baudrate 125k */
#define DN_FAL_BAUDRATE_125                                                  (3)
/**
 * @}
 */

/**
 * @defgroup Download_Parameter_Def Download, Upload Parameter Definition
 * @{
 * Defines used in Download, Upload Parameters. #DEVNET_FAL_CMD_DOWNLOAD_REQ,
 * #DEVNET_FAL_CMD_UPLOAD_REQ
 */
/*! Download areas bus parameter of the master */
#define DN_FAL_DOWNLOAD_AREA_BUS_PARAMETER                                   (0)

/*! Download areas slave parameter */
#define DN_FAL_DOWNLOAD_AREA_SLAVE_PARAMETER                                 (1)

/*! Download areas server parameter of the master */
#define DN_FAL_DOWNLOAD_AREA_SERVER_PARAMETER                                (2)

/*! Download areas device parameter of the master */
#define DN_FAL_DOWNLOAD_AREA_DEVICE_PARAMETER                                (3)
/**
 * @}
 */

/**
 * @defgroup Operating_Mode Definition of Operating Mode
 * @{
 * Defines used in #DEVNET_FAL_CMD_SET_MODE_REQ, #DEVNET_FAL_CMD_SET_MODE_IND
 */
/*! Operate mode: Offline */
#define DN_FAL_MODE_OFFLINE                                               (0x00)

/*! Operate mode: Stop */
#define DN_FAL_MODE_STOP                                                  (0x40)

/*! Operate mode: Idle */
#define DN_FAL_MODE_IDLE                                                  (0x80)

/*! Operate mode: Run */
#define DN_FAL_MODE_RUN                                                   (0xC0)
/**
 * @}
 */

/*!
 * @ingroup Miscellaneous
 * @{
 * */
/*! Bus parameter system flags. Device go online automatically after configured
 *  @see ::DN_FAL_BUS_PRM_Ttag::ulConfigFlags
 */
#define DN_FAL_MSK_BUS_PRM_SYS_FLAG_CTRL_RELEASE                      0x00000001
/*! Bus parameter system flags reserved.
 *  @see ::DN_FAL_BUS_PRM_Ttag::ulConfigFlags
 */
#define DN_FAL_MSK_BUS_PRM_SYS_FLAG_RESERVED                          0xFFFFFFFE


/*! Bus parameter configuration flags. Auto clear after heartbeat timeout
 * @see ::DN_FAL_BUS_PRM_Ttag::ulConfigFlags */
#define DN_FAL_MSK_BUS_PRM_CFG_FLAG_AUTOCLEAR                         0x00000001
/*! Bus parameter configuration flags. Endianess. Not use in this stack.
 * @see ::DN_FAL_BUS_PRM_Ttag::ulConfigFlags */
//#define DN_FAL_MSK_BUS_PRM_CFG_FLAG_INTEL_MOTOROLA                    0x00000002
/*! Bus parameter configuration flags. Continue on bus off.
 * @see ::DN_FAL_BUS_PRM_Ttag::ulConfigFlags */
#define DN_FAL_MSK_BUS_PRM_CFG_FLAG_CONTINUE_ON_BOI                   0x00000004
/*! Bus parameter configuration flags. Reserved
 * @see ::DN_FAL_BUS_PRM_Ttag::ulConfigFlags */
#define DN_FAL_MSK_BUS_PRM_CFG_FLAG_RESERVED                          0xFFFFFFF8

/*! Bus parameter enable flags. @see: ::DN_FAL_BUS_PRM_Ttag::ulEnableFlags */
#define DN_FAL_MSK_BUS_PRM_ENABLE_FLAG_RESERVED                       0xFFFFFFFF

/*! Device Parameter configuration flags. Reserved */
#define DN_FAL_MSK_DEV_PRM_CFG_FALG_RESERVED                          0xFFFFFFFF

/*! Device Parameter enable flags. See ::DN_FAL_DEV_PRM_Ttag::ulEnableFlags  */
#define DN_FAL_MSK_DEV_PRM_ENABLE_VENDORID                            0x00000001
/*! Device Parameter enable flags. See ::DN_FAL_DEV_PRM_Ttag::ulEnableFlags  */
#define DN_FAL_MSK_DEV_PRM_ENABLE_PRODUCTTYPE                         0x00000002
/*! Device Parameter enable flags. See ::DN_FAL_DEV_PRM_Ttag::ulEnableFlags  */
#define DN_FAL_MSK_DEV_PRM_ENABLE_PRODUCTCODE                         0x00000004
/*! Device Parameter enable flags. See ::DN_FAL_DEV_PRM_Ttag::ulEnableFlags  */
#define DN_FAL_MSK_DEV_PRM_ENABLE_MAJORMINORREV                       0x00000008
/*! Device Parameter enable flags. See ::DN_FAL_DEV_PRM_Ttag::ulEnableFlags  */
#define DN_FAL_MSK_DEV_PRM_ENABLE_SERIALNR                            0x00000010
/*! Device Parameter enable flags. See ::DN_FAL_DEV_PRM_Ttag::ulEnableFlags  */
#define DN_FAL_MSK_DEV_PRM_ENABLE_PRODUCTNAME                         0x00000020
/*! Device Parameter enable flags. See ::DN_FAL_DEV_PRM_Ttag::ulEnableFlags  */
#define DN_FAL_MSK_DEV_PRM_ENABLE_QUICK_CONNECT                       0x00000040
/*! Device Parameter enable flags. See ::DN_FAL_DEV_PRM_Ttag::ulEnableFlags  */
#define DN_FAL_MSK_DEV_PRM_ENABLE_RESERVED                            0xFFFFFF80

#define DNM_ENMSK_VENDORID               DN_FAL_MSK_DEV_PRM_ENABLE_VENDORID
#define DNM_ENMSK_PRODUCTTYPE            DN_FAL_MSK_DEV_PRM_ENABLE_PRODUCTTYPE
#define DNM_ENMSK_PRODUCTCODE            DN_FAL_MSK_DEV_PRM_ENABLE_PRODUCTCODE
#define DNM_ENMSK_MAJORMINORREV          DN_FAL_MSK_DEV_PRM_ENABLE_MAJORMINORREV
#define DNM_ENMSK_SERIALNR               DN_FAL_MSK_DEV_PRM_ENABLE_SERIALNR
#define DNM_ENMSK_PRODUCTNAME            DN_FAL_MSK_DEV_PRM_ENABLE_PRODUCTNAME
#define DNM_ENMSK_QUICK_CONNECT          DN_FAL_MSK_DEV_PRM_ENABLE_QUICK_CONNECT
#define DNM_ENMSK_RESERVED               DN_FAL_MSK_DEV_PRM_ENABLE_RESERVED

/*! Life List Definition. @see ::DN_FAL_LIFELIST_CNF_Ttag::abDevices */
#define DN_FAL_LIFELIST_OWN_MAC                                             0xFF
/*! Life List Definition. @see ::DN_FAL_LIFELIST_CNF_Ttag::abDevices */
#define DN_FAL_LIFELIST_MAC                                                 0x01
/*! Life List Definition. @see ::DN_FAL_LIFELIST_CNF_Ttag::abDevices */
#define DN_FAL_LIFELIST_NO_MAC                                              0x00
/**
 * @}
 */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(DEVNET_FAL_PUBLIC)
#endif


/******************************************************************************/
/* START: Definition of shared memory interface DVENET FAL task               */


/** module definition *********************************************************/
/*! @see ::I_O_MODULE_Ttag::bDataType */
#define DN_FAL_MSK_OUTPUT_MODULE        (0x80)
/*! @see ::I_O_MODULE_Ttag::bDataType */
#define DN_FAL_MSK_WORD_MODULE          (0x40)

/*! I/O module information definition *****************************************/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_MODULE_INFO_Ttag
{
 TLR_UINT8    bModuleType;     /**<module type. @see DN_FAL_MSK_OUTPUT_MODULE */
 TLR_UINT8    bModuleLength;   /*!module length. 0 to 255                     */
 TLR_UINT32   ulOffset;     /**<Module start offset in between io connection. */
 TLR_UINT8    abReserved[2];  /**< reserved. Set to zero                      */
}
DN_FAL_MODULE_INFO_T;

/*! I/O connection definition *************************************************/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_IO_CNXN_Ttag
{
  TLR_UINT32              ulLength;    /**< connection length                 */
  TLR_UINT32              ulStatus;    /**< connection status                 */
  TLR_UINT32              ulIoModules; /**< number of I/O modules of this Cxnx*/
  DN_FAL_MODULE_INFO_T*   patModuleInfo;/**<pointer to module info array      */
  TLR_UINT8*              pabData;     /**< pointer to connection data        */
}
DN_FAL_IO_CNXN_T;

/*! connection list entry *****************************************************/
typedef __PACKED_PRE struct __PACKED_POST  DN_FAL_CNXN_LIST_ENTRY_Ttag
{
  struct
  {
    TLR_VOID  FAR *ptNxt;
    TLR_VOID  FAR *ptPrv;
  }
  tDblLnk;

  TLR_HANDLE          hTriBuf;
  DN_FAL_IO_CNXN_T*   ptCurCnxn;
}
DN_FAL_CNXN_LIST_ENTRY_T;

/*! connection list entry *****************************************************/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_COMMON_DIAG_Ttag
{
  TLR_UINT32    ulSlaveState; /**< RCX_SLAVE_STATE_UNDEFINED = 0x00000000,
                                   RCX_SLAVE_STATE_OK        = 0x00000001,
                                   RCX_SLAVE_STATE_FAILED    = 0x00000002 */
  TLR_UINT32  ulSlaveErrLogInd;                                /*! Not used */
  TLR_UINT32  ulNumOfConfigSlaves;/**<Number of node configured as slave.Max 64*/
  TLR_UINT32  ulNumOfActiveSlaves;/**<Number of slave in data exchange). Max 64*/
  TLR_UINT32  ulNumOfDiagSlaves;  /**<Number of slave have diagnose. Max 64    */
}
DN_FAL_COMMON_DIAG_T;

/*!Extended Diagose Structure */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_EXT_DIAG_Ttag
{
  TLR_UINT8      bGlobalBits;       /**<Collective global status bits         */
  #define DN_FAL_GLB_BIT_CTRL 0x01  /**< Faulty parameter                     */
  #define DN_FAL_GLB_BIT_ACLR 0x02  /**< Auto clear error                     */
  #define DN_FAL_GLB_BIT_NEXC 0x04  /**< At least one slave not exchange data */
  #define DN_FAL_GLB_BIT_FAT  0x08  /**< Fatal error                          */
  #define DN_FAL_GLB_BIT_EVE  0x10  /**< Busevent error                       */
  #define DN_FAL_GLB_BIT_NRDY 0x20  /**< Application is not ready             */
  #define DN_FAL_GLB_BIT_DMAC 0x40  /**< Duplicate MAC ID detected            */
  #define DN_FAL_GLB_BIT_PDUP 0x80  /**< Check duplicate MAC ID in process    */

  TLR_UINT8     bDNM_State;          /**< Operate mode
                                      * DN_FAL_MODE_OFFLINE (0x00)
                                      * DN_FAL_MODE_STOP    (0x40)
                                      * DN_FAL_MODE_IDLE    (0x80)
                                      * DN_FAL_MODE_RUN     (0xC0)            */

  __PACKED_PRE struct __PACKED_POST  /**< Pending device error                */
  {
    TLR_UINT8   bDevAddr;           /**<Error device address. Max 63          */
    TLR_UINT8   bErrEvent;          /**<Error number. Search for DNM_EVX_ERR..*/
  }
  tError;

  TLR_UINT16    usBus_Err_Cnt;       /**<Bus event counter                    */
  TLR_UINT16    usBus_Off_Cnt;       /**<Bus timeout counter                  */

  TLR_UINT32    ulDNM_ExtraErr;      /**<Extra error code for DNM. TLR_E_ ... */
  TLR_UINT8     abReserved[4];

                                    /**<Bit wise operate /diag state per slave*/
  TLR_UINT8     abDv_cfg_active[8]; /**< Configured slave declared as active  */
  TLR_UINT8     abDv_cfg_inactive[8];/**<Configured slave declared as inactive*/
  TLR_UINT8     abDv_state_expl[8]; /**< Established explicit connection      */
  TLR_UINT8     abDv_state_io[8];   /**< Established I/O connection           */
  TLR_UINT8     abDvDiag[8];        /**< Slaves with diagnostic               */
  TLR_UINT8     abDv_reserved[8];   /**< Reserved field                       */


}
DN_FAL_EXT_DIAG_T;

typedef __PACKED_PRE struct __PACKED_POST DN_FAL_DIAGNOSTICS_Ttag
{
  DN_FAL_COMMON_DIAG_T  tCommonDiag; /**<Common Diagnosis                     */
  DN_FAL_EXT_DIAG_T     tExtDiag;    /**<Extended Diagnosis                   */

}
DN_FAL_DIAGNOSTICS_T;

typedef TLR_VOID (FAR *DN_FAL_CALLBACK_DIAG_UPDATE_FN)(TLR_VOID FAR *pvPrm);

/*! shared memory to DEVNET FAL task ******************************************/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_AP_S_MEM_Ttag
{
  TLR_UINT8                          bMajVer;               /**<Major Version */
  TLR_UINT8                          bMinVer;               /**<Minor Version */
  TLR_UINT16                         usSize;       /**<Size of this structure */

  TLR_HANDLE                         hTriBufDiag;/**<Triple buffer of diagnosis*/
  DN_FAL_DIAGNOSTICS_T*              ptCurDiag;  /**<Pointer to current diag   */
  DN_FAL_CALLBACK_DIAG_UPDATE_FN     fnDiagUpdate;/**<Update call back function*/
  TLR_VOID FAR*                      pvDiagUpdatePrm;/**<call back parameter   */

  /*! Input Connection double link list */
  TLR_UINT32                         ulNumInCnxn;/**<Number input connections */
  DN_FAL_CNXN_LIST_ENTRY_T*          ptInCnxnLst;/**<Pointer to linked-list   */

  /*! Output Connection double link list */
  TLR_UINT32                         ulNumOutCnxn;/**<Number output connection*/
  DN_FAL_CNXN_LIST_ENTRY_T*          ptOutCnxnLst;/**<Pointer to the link-list*/

  /*!Actual size used as input in data exchange with slaves   */
  TLR_UINT32                         ulDpmInActualUsedSz;
  /*!Actual size used as output in data exchange with slaves   */
  TLR_UINT32                         ulDpmOutActualUsedSz;
}
DN_FAL_AP_S_MEM_T;

/* END: Definition of shared memory                                           */
/******************************************************************************/


/** busparameter **************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_BUS_PRM_Ttag
{
  TLR_UINT32   ulSystemFlags;/**<@see Miscellaneous. i.e.#DN_FAL_MSK_BUS_PRM_SYS_FLAG_CTRL_RELEASE */
  TLR_UINT32   ulWdgTime;        /**<Watchdog                                 */
  TLR_UINT32   ulOwnMacId;       /**<Device MAC ID. Max 63                    */
  TLR_UINT32   ulBaudrate;       /**<Device Baudrate. @see Baudrate           */
  TLR_UINT32   ulConfigFlags;/**<@see Miscellaneous. i.e.#DN_FAL_MSK_BUS_PRM_CFG_FLAG_AUTOCLEAR */
  TLR_UINT32   ulEnableFlags;    /**<Set to 0                                 */
  TLR_UINT8    abReserved[40];   /**<Reserved                                 */
}
DN_FAL_BUS_PRM_T;

/** device parameter **********************************************************/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_DEV_PRM_Ttag
{
  TLR_UINT32   ulConfigFlags;    /**<Configuration flags.Set to 0             */
  TLR_UINT32   ulEnableFlags;/**<@see Miscellaneous. i.e #DN_FAL_MSK_DEV_PRM_ENABLE_VENDORID */
  TLR_UINT16   usVendorId;       /**<Vendor ID                                */
  TLR_UINT16   usProductType;    /**<Product Type                             */
  TLR_UINT16   usProductCode;    /**<Product Code                             */
  TLR_UINT8    bMinorRev;        /**<Minor Version                            */
  TLR_UINT8    bMajorRev;        /**<Major Version                            */
  TLR_UINT32   ulSerialNumber;   /**<Serial Number                            */
  TLR_UINT8    abReserved[3];    /**<Reserved                                 */
  TLR_UINT8    bProductNameLen;  /**<Product Name length                      */
  TLR_UINT8    abProductName[32];/**<Product Name                             */
  TLR_UINT8    abReserved2[8];   /**<Reserved                                 */
}
DN_FAL_DEV_PRM_T;

/** server parameter **********************************************************/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SRV_PRM_Ttag
{
  TLR_UINT8    bSrvConsConnSize;/**<consumed I/O connection size as server    */
  TLR_UINT16   usConsOffset;    /**<offset addr in input area for server input*/
  TLR_UINT8    bSrvProdConnSize;/**<produced I/O connection size as server    */
  TLR_UINT16   usProdOffset;  /**<offset addr in output area for server output*/
  TLR_UINT8    abReserved[58];  /**<reserved                                  */
}
DN_FAL_SRV_PRM_T;

/** slave parameter ***********************************************************/
typedef __PACKED_PRE struct __PACKED_POST DN_DEV_PRM_HEADER_Ttag
{
  TLR_UINT16      usDevParaLen;   /**< length of whole parameter data set     */

  TLR_UINT8       bDvFlag;         /**< device related flags                  */
  #define DN_DV_FLAG_UCMM_SUPP     0x01/**<UCMM manager supported by device   */
  #define DN_DV_FLAG_QUICK_CONNECT 0x02/**<key check Quick Connect enabled    */
  #define DN_DV_FLAG_KEY_VENDOR    0x04/**<key check Vendor ID on/off         */
  #define DN_DV_FLAG_KEY_DTYPE     0x08/**<key check Device Type on/off       */
  #define DN_DV_FLAG_KEY_PCODE     0x10/**<key check Product Code on/off      */
  #define DN_DV_FLAG_KEY_REV       0x20/**<key check for Revision on/off      */
  #define DN_DV_FLAG_ACTIVE        0x80/**<set device access active           */
  #define DN_DV_FLAG_RESERVED      0x42/**<Reserved flags                     */

  TLR_UINT8       bUcmmGroup;       /**< dynamic UCMM connection group        */
  #define DNM_GROUP_1 0
  #define DNM_GROUP_2 1
  #define DNM_GROUP_3 3
  TLR_UINT16      usRecFragTimer;  /**< timeout value for reconnection and for
                       fragmented transfer also usFragTimeout. In milliseconds*/
  TLR_UINT16      usVendorID;      /**< Vendor ID                             */
  TLR_UINT16      usDeviceType;    /**< Device Type                           */
  TLR_UINT16      usProductCode;   /**< Product code                          */
  TLR_UINT8       bMajorRevision;  /**< Revision major digit. Max 255         */
  TLR_UINT8       bMinorRevision;  /**< Revision minor digit. Max 127         */

  TLR_UINT8       bOctetString[2];/**< reserved field                         */
}
DN_DEV_PRM_HEADER_T;

typedef struct DNM_DBLY_LST_Ttag                        /* double linked list */
{
  TLR_VOID*   ptNxt;

  TLR_VOID*   ptPrv;

}
DNM_DBLY_LST_T;

typedef __PACKED_PRE struct __PACKED_POST DNM_SLV_PRM_LIST_Ttag
{
  DNM_DBLY_LST_T      tLink;

  TLR_UINT32          ulSlvMacId;   /**<Slave MAC Id. Max 63                  */

  DN_DEV_PRM_HEADER_T tSlvPrm;      /**< Slave Parameter                      */

}
DNM_SLV_PRM_LIST_T;

typedef __PACKED_PRE struct __PACKED_POST DN_PRED_MSTSL_IO_OBJ_HEADER_Ttag
{
  TLR_UINT8  bConnectionType;/**<type of connection which shall be established*/
  #define DN_TYPE_CYCLIC             0x08/**<cyclic connection                */
  #define DN_TYPE_CHG_OF_STATE       0x04/**<change of state connection       */
  #define DN_TYPE_BIT_STROBED        0x02/**<bit strobe connection            */
  #define DN_TYPE_POLLED             0x01/**<polled connection                */
  #define DN_TYPE_CYCLIC_ACK         0x20/**<cyclic connection                */
  #define DN_TYPE_CHG_OF_STATE_ACK   0x10/**<change of state connection
  TLR_UINT8  bWatchdogTimeoutAction;        behavior when watchdog times out  */
  #define DN_TRANSITION_TO_TIMEOUT   0x00/**<external reset must be performed */
  #define DN_AUTO_DELETE             0x01/**<delete connection automatically  */
  #define DN_AUTO_RESET              0x02/**<restart watchdog timer again     */
  TLR_UINT16 usProdInhibitTime;          /**<production inhibit time im msec  */
  TLR_UINT16 usExpPacketRate;           /**<established cnxn supervision timer*/
  TLR_UINT8  bNumOfIOModules;            /**<number of following I/O modules  */
}
DN_PRED_MSTSL_IO_OBJ_HEADER_T;

typedef __PACKED_PRE struct __PACKED_POST DN_IO_MODULE_Ttag
{
  TLR_UINT8 bDataType;          /**<data type of I/O module                   */
  #define DN_OUTPUT        0x80 /**<selection input / output                  */
  #define DN_WORD_MODULE   0x40 /**<indication if word swap shall be performed*/
  TLR_UINT8 bDataSize;          /**<data size of module in multiples of bytes */
}
DN_IO_MODULE_T;

typedef __PACKED_PRE struct __PACKED_POST DN_PRED_MSTSL_CONNOBJ_Ttag
{
  DN_PRED_MSTSL_IO_OBJ_HEADER_T tPredMstSlObjHeader;/**<header for each Cxnx  */
  DN_IO_MODULE_T                atIOModule[1];      /**<I/O modules for Cxnx  */
}
DN_PRED_MSTSL_CONNOBJ_T;

typedef __PACKED_PRE struct __PACKED_POST DN_PRED_MSTSL_CFG_DATA_Ttag
{
  TLR_UINT16 usPredMstslCfgDataLen;/**<len of the predef.MstSl. cfg. data     */
  DN_PRED_MSTSL_CONNOBJ_T atConnObjInst[1];/**<connection structure           */
}
DN_PRED_MSTSL_CFG_DATA_T;

typedef __PACKED_PRE struct __PACKED_POST DN_PRED_MSTSL_ADD_TAB_Ttag
{
  TLR_UINT16 usAddTabLen;          /**<whole length of addtional table field  */
  TLR_UINT8  bInputCount;          /**<number of inputs in the offset table   */
  TLR_UINT8  bOutputCount;         /**<number of output in the offset table   */
  TLR_UINT16 ausIOOffsets[1];      /**<process data offset table              */
}
DN_PRED_MSTSL_ADD_TAB_T;

typedef __PACKED_PRE struct __PACKED_POST DN_SET_ATTR_DATA_Ttag
{
  TLR_UINT16      usClassID;  /**<class ID to be addressed. See CIP_Class_Code*/
  TLR_UINT16      usInstanceID;  /**<instance in this class be addressed      */
  TLR_UINT8       bAttributeID;  /**<attribute which shall be changed         */
  TLR_UINT8       bDataCnt;      /**<size of the following data field         */
  TLR_UINT8       abData[1];     /**<attribute value                          */
}
DN_SET_ATTR_DATA_T;

typedef __PACKED_PRE struct __PACKED_POST DNM_EXPL_SET_ATTR_DATA_Ttag
{
  TLR_UINT16         usAttrDataLen;   /**<length of the parameter data field  */
  DN_SET_ATTR_DATA_T atSetAttrData[1];/**< n parameter data fields            */
}
DN_EXPL_SET_ATTR_DATA_T;

typedef __PACKED_PRE struct __PACKED_POST DN_UCMM_CONN_OBJ_CFG_DATAtag
{
  unsigned short usCfgDataLen;    /**< second connection table                */
}
DN_UCMM_CONN_OBJ_CFG_DATA;      /**< not used at the moment                   */

typedef __PACKED_PRE struct __PACKED_POST DN_UCMM_CONN_OBJ_ADD_TABtag
{
  TLR_UINT16      usAddTabLen;    /**<whole length of addtional table field   */
  TLR_UINT8       bInputCount;    /**<number of inputs in the offset table    */
  TLR_UINT8       bOutputCount;   /**<number of output in the offset table    */
  TLR_UINT16      ausIOOffsets[1];/**<process data offset table               */
}
DN_UCMM_CONN_OBJ_ADD_TAB;

/** SDU: Download Data Structure***********************************************/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_DOWNLOAD_REQ_Ttag
{
  TLR_UINT16 usArea;         /**< @see DN_FAL_DOWNLOAD_AREA_BUS_PARAMETER ... */
  TLR_UINT16 usSubArea; /**<Slave MACID, #DN_FAL_DOWNLOAD_AREA_SLAVE_PARAMETER*/
  TLR_UINT8  abData[1000];
}
DN_FAL_SDU_DOWNLOAD_REQ_T;

/** SDU: Upload Data Structure*************************************************/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_UPLOAD_CNF_Ttag
{
  TLR_UINT16 usArea;                         /**< Area the same as in request */
  TLR_UINT16 usSubArea;                  /**< Sub area the same as in request */
  TLR_UINT8  abData[1000];
}
DN_FAL_SDU_UPLOAD_CNF_T;

/*! @see DN_FAL_PACKET_DOWNLOAD_CNF_T */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_DOWNLOAD_CNF_Ttag
{
  TLR_UINT16 usArea;                         /**< Area the same as in request */
  TLR_UINT16 usSubArea;                  /**< Sub area the same as in request */
}
DN_FAL_SDU_DOWNLOAD_CNF_T;

/*!@see DN_FAL_PACKET_UPLOAD_REQ_T */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_UPLOAD_REQ_Ttag
{
  TLR_UINT16 usArea;                       /**< See DN_FAL_DOWNLOAD_AREA_ ... */
  TLR_UINT16 usSubArea; /**<Slave MACID, #DN_FAL_DOWNLOAD_AREA_SLAVE_PARAMETER*/
}
DN_FAL_SDU_UPLOAD_REQ_T;

#define DN_FAL_INIT_MODE_RESET 0x00000000

/** SDU: Init req/cnf. @see DN_FAL_PACKET_INIT_REQ_T***************************/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_INIT_REQ_Ttag
{
  TLR_UINT32 ulMode;                                             /**< Set to 0 */
}
DN_FAL_SDU_INIT_REQ_T;

/* @see DN_FAL_PACKET_INIT_CNF_T */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_INIT_CNF_Ttag
{
  TLR_UINT32 ulMode;                                            /**< Set to 0 */
}
DN_FAL_SDU_INIT_CNF_T;

/** SDU: Set Mode req/cnf *****************************************************/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_SET_MODE_REQ_Ttag
{
  TLR_UINT32 ulMode;                              /**< @see Operating_Mode ...*/
  TLR_UINT8  ubExtErrCode;                           /**< Extra error code    */
}
DN_FAL_SDU_SET_MODE_REQ_T;

/* @see DN_FAL_PACKET_SET_MODE_REQ_T */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_SET_MODE_CNF_Ttag
{
  TLR_UINT32 ulMode;                              /**< The same as in request */
}
DN_FAL_SDU_SET_MODE_CNF_T;

/** SDU: Set Mode ind/res.@see DN_FAL_PACKET_SET_MODE_IND_T *******************/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_SET_MODE_IND_Ttag
{
  TLR_UINT32 ulMode;                              /**< @see Operating_Mode ...*/
  TLR_UINT32 ulReason;                          /**< Reason of the indication */
#define DUP_MAC_ID_ERROR 0x00000001
#define SUPPLY_VOLTAGE_ERROR 0x00000002
}
DN_FAL_SDU_SET_MODE_IND_T;

/*! @see DN_FAL_PACKET_SET_MODE_RES_T */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_SET_MODE_RES_Ttag
{
  TLR_UINT32 ulMode;                              /**< @see Operating_Mode ...*/
}
DN_FAL_SDU_SET_MODE_RES_T;

/** SDU: Clear Config req/cnf. @see DN_FAL_PACKET_CLEAR_CONFIG_REQ_T***********/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_CLR_CONFIG_REQ_Ttag
{
  TLR_UINT32 ulCfgArea;                                         /**< Not used */
}
DN_FAL_SDU_CLR_CONFIG_REQ_T;

/** SDU: Fault ind/res. @see DN_FAL_PACKET_FAULT_IND_T*************************/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_FAULT_IND_Ttag
{
  TLR_UINT32 ulFault;                                    /** Fault indication */
}
DN_FAL_SDU_FAULT_IND_T;

/** SDU: GetSet Attribute. @see DN_FAL_PACKET_GETSET_ATT_REQ_T*****************/
#define DN_FAL_SDU_GETSET_ATT_MAX_DATA  (512)
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_GETSET_ATT_REQ_Ttag
{
  TLR_UINT8  bDevMacId;                               /**< MAC ID of the slave*/
  TLR_UINT8  abReserved[3];                           /**< Reserved           */
  TLR_UINT16 usClass;                                 /**< Class ID           */
  TLR_UINT16 usInstance;                              /**< Instance ID        */
  TLR_UINT16 usAttribute;                             /**< Attribute ID       */
  TLR_UINT16 usReserved;                              /**< Reserved           */
  TLR_UINT8  abAttData[DN_FAL_SDU_GETSET_ATT_MAX_DATA];/**< Attribute Data    */
}
DN_FAL_SDU_GETSET_ATT_REQ_T;

/*! @see DN_FAL_PACKET_GETSET_ATT_CNF_T */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_GETSET_ATT_CNF_Ttag
{
  TLR_UINT8  bDevMacId;                             /**< MAC ID of the slave */
  TLR_UINT8  abReserved[3];                         /**< Reserved            */
  TLR_UINT16 usClass;                               /**< Class ID            */
  TLR_UINT16 usInstance;                            /**< Instance ID         */
  TLR_UINT16 usAttribute;                           /**< Attribute ID        */
  TLR_UINT8  bGenErr;     /**< General Error. @see CIP_General_Error_Code ... */
  TLR_UINT8  bAddErr;                                  /**< Additional error  */
  TLR_UINT8  abAttData[DN_FAL_SDU_GETSET_ATT_MAX_DATA];/**< Attribute data    */
}
DN_FAL_SDU_GETSET_ATT_CNF_T;

/*! @see DN_FAL_PACKET_BTS_REQ_T */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_BTS_REQ_Ttag
{
  TLR_UINT64 ullStrobeMsk;                                /**< Strobe Mask    */
  TLR_UINT64 ullStrobeCmd;                                /**< Strobe Command */
  TLR_UINT32 ulTimeOut;                   /**< Strobe timeout in milliseconds */
}
DN_FAL_BTS_REQ_T;

/* @see DN_FAL_BTS_CNF_T */
typedef __PACKED_PRE struct __PACKED_POST DM_FAL_BTS_MSG_Tag
{
  TLR_UINT8 bNodeAddr;                                 /**< Bitstrobed MAC ID */
  TLR_UINT8 bLen;                                      /**< Data Length       */
  TLR_UINT8 bRsrv;                                     /**< Reserved          */
  TLR_UINT8 abData[8];                                 /**< Bitstrobe Data    */
}
DM_FAL_BTS_MSG_T;

/*! @see DN_FAL_PACKET_BTS_CNF_T */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_BTS_CNF_Ttag
{
  TLR_UINT64       ullStatusList; /**< Mask of node response to the bitstrobe */
  DM_FAL_BTS_MSG_T atBtsData[64]; /**< Bitstrobe data                         */
}
DN_FAL_BTS_CNF_T;

/*! @see DN_FAL_PACKET_LIFELIST_REQ_T */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_LIFELIST_REQ_Ttag
{
  TLR_UINT32 ulTimeOut;                 /**< Lifelist timeout in milliseconds */
}
DN_FAL_LIFELIST_REQ_T;

/*! @see DN_FAL_PACKET_LIFELIST_CNF_T */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_LIFELIST_CNF_Ttag
{
  TLR_UINT8 abDevices[64];                           /**< Livelift found list */
}
DN_FAL_LIFELIST_CNF_T;

/*!This packe is used with #DEVNET_FAL_CMD_AP_REGISTER_REQ. This service
 * is used to register the application at the protocol stack. It is required
 * for correct operation as without calling this service no indications would be
 * sent back to the sending task or queue.
 * This service shall be sent as the very first command before interacting with
 * the stack.
*/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_AP_REGISTER_REQ_Ttag
{
  TLR_PACKET_HEADER_T           tHead;                 /**< Packet Header     */
}
DN_FAL_PACKET_AP_REGISTER_REQ_T;
#define DN_FAL_AP_REGISTER_REQ_SIZE (0)
/*! @see DEVNET_FAL_CMD_AP_REGISTER_CNF */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_AP_REGISTER_CNF_Ttag
{
  TLR_PACKET_HEADER_T           tHead;                 /**< Packet Header     */
}
DN_FAL_PACKET_AP_REGISTER_CNF_T;
#define DN_FAL_AP_REGISTER_CNF_SIZE (0)


/*! This packet is used with #DEVNET_FAL_CMD_FAULT_IND. This indication
 * packet is sent from the DeviceNet Master protocol stack to the user
 * application in order to indicate a fault.  The reason why a fault occurred
 * is coded in the ulFault variable. */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_FAULT_IND_Ttag
{
  TLR_PACKET_HEADER_T           tHead;                 /**< Packet Header     */
  DN_FAL_SDU_FAULT_IND_T        tData;                 /**< Packet data       */
}
DN_FAL_PACKET_FAULT_IND_T;
#define DN_FAL_FAULT_IND_SIZE (sizeof(DN_FAL_SDU_FAULT_IND_T))
/*! @see DEVNET_FAL_CMD_FAULT_RES */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_FAULT_RES_Ttag
{
  TLR_PACKET_HEADER_T           tHead;                 /**< Packet Header     */
}
DN_FAL_PACKET_FAULT_RES_T;
#define DN_FAL_FAULT_RES_SIZE (0)


/*! The command #DEVNET_FAL_CMD_DOWNLOAD_REQ is used to download a configuration
 * to the DeviceNet stack. The download is divided into so called areas like
 * slave parameter sets or the bus parameter set.*/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_DOWNLOAD_REQ_Ttag
{
  TLR_PACKET_HEADER_T           tHead;                 /**< Packet Header     */
  DN_FAL_SDU_DOWNLOAD_REQ_T     tData;                 /**< Packet data       */
}
DN_FAL_PACKET_DOWNLOAD_REQ_T;

/*! @see DEVNET_FAL_CMD_DOWNLOAD_CNF */
#define DN_FAL_DOWNLOAD_CNF_SIZE sizeof(DN_FAL_SDU_DOWNLOAD_CNF_T)
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_DOWNLOAD_CNF_Ttag
{
  TLR_PACKET_HEADER_T           tHead;                 /**< Packet Header     */
  DN_FAL_SDU_DOWNLOAD_CNF_T     tData;                 /**< Packet data       */
}
DN_FAL_PACKET_DOWNLOAD_CNF_T;

/*! The command #DEVNET_FAL_CMD_UPLOAD_REQ is used to upload a configuration
 * (i.e. a complete set of parameters) from the DeviceNet stack to the
 * application. The download is divided into so called areas like bus,
 * device, slave or server parameter sets. */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_UPLOAD_REQ_Ttag
{
  TLR_PACKET_HEADER_T           tHead;                 /**< Packet Header     */
  DN_FAL_SDU_UPLOAD_REQ_T     tData;                   /**< Packet data       */
}
DN_FAL_PACKET_UPLOAD_REQ_T;

#define DN_FAL_UPLOAD_CNF_SIZE sizeof(DN_FAL_SDU_UPLOAD_CNF_T)
/*! @see DEVNET_FAL_CMD_UPLOAD_CNF */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_UPLOAD_CNF_Ttag
{
  TLR_PACKET_HEADER_T           tHead;                 /**< Packet Header     */
  DN_FAL_SDU_UPLOAD_CNF_T       tData;                 /**< Packet data       */
}
DN_FAL_PACKET_UPLOAD_CNF_T;


/*! This packet clears the configuration area. #DEVNET_FAL_CMD_CLR_CONFIG_REQ */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_CLEAR_CONFIG_REQ_Ttag
{
  TLR_PACKET_HEADER_T           tHead;                 /**< Packet Header     */
  DN_FAL_SDU_CLR_CONFIG_REQ_T   tData;                 /**< Packet data       */
}
DN_FAL_PACKET_CLEAR_CONFIG_REQ_T;

/*! @see DEVNET_FAL_CMD_CLR_CONFIG_CNF */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_CLEAR_CONFIG_CNF_Ttag
{
  TLR_PACKET_HEADER_T             tHead;               /**< Packet Header     */
}
DN_FAL_PACKET_CLEAR_CONFIG_CNF_T;


/*! The initialization request is used to force the DeviceNet protocol stack
 * into a determined state. e.g. to resetting the stack. The mode of the init
 * command determines the method and initialization action.
 * @see DEVNET_FAL_CMD_INIT_REQ
 */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_INIT_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                  /* Packet Header    */
  DN_FAL_SDU_INIT_REQ_T           tData;                  /* Packet data      */
}
DN_FAL_PACKET_INIT_REQ_T;

/*! The initialization confirmation.
 * @see DEVNET_FAL_CMD_INIT_CNF, DN_FAL_PACKET_INIT_REQ_T
 */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_INIT_CNF_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                /**< Packet Header     */
  DN_FAL_SDU_INIT_CNF_T           tData;                /**< Packet data       */
}
DN_FAL_PACKET_INIT_CNF_T;


/*! The command #DEVNET_FAL_CMD_SET_MODE_REQ is used to set the operational
 *  mode of the DevNetFAL-Task.
 */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_SET_MODE_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                /**< Packet Header     */
  DN_FAL_SDU_SET_MODE_REQ_T       tData;                /**< Packet data       */
}
DN_FAL_PACKET_SET_MODE_REQ_T;

/*! @see DEVNET_FAL_CMD_SET_MODE_CNF */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_SET_MODE_CNF_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                /**< Packet Header     */
  DN_FAL_SDU_SET_MODE_CNF_T       tData;                /**< Packet data       */
}
DN_FAL_PACKET_SET_MODE_CNF_T;

/*!Used with #DEVNET_FAL_CMD_SET_MODE_IND. This indication is issued each time
 * when the DeviceNet operation mode (supplied in parameter ulMode) changes
 */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_SET_MODE_IND_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                /**< Packet Header     */
  DN_FAL_SDU_SET_MODE_IND_T       tData;                /**< Packet data       */
}
DN_FAL_PACKET_SET_MODE_IND_T;

/*! @see DEVNET_FAL_CMD_SET_MODE_RES */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_SET_MODE_RES_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                /**< Packet Header     */
  DN_FAL_SDU_SET_MODE_RES_T       tData;                /**< Packet data       */
}
DN_FAL_PACKET_SET_MODE_RES_T;

/*! This indication will be issued when new output data are available.
    Neither the indication packet nor the response packet have any parameters.
    @see DEVNET_FAL_CMD_NEW_OUTPUT_IND
*/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_NEW_OUTPUT_IND_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                /**< Packet Header    */
}
DN_FAL_PACKET_NEW_OUTPUT_IND_T;

/*! @see DEVNET_FAL_CMD_NEW_OUTPUT_RES */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_NEW_OUTPUT_RES_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                /**< Packet Header    */
}
DN_FAL_PACKET_NEW_OUTPUT_RES_T;

/** PACKET: New input ind/res *************************************************/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_NEW_INPUT_IND_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                /**< Packet Header    */
}
DN_FAL_PACKET_NEW_INPUT_IND_T;

typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_NEW_INPUT_RES_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                /**< Packet Header    */
}
DN_FAL_PACKET_NEW_INPUT_RES_T;

/*! The packet uses #DEVNET_FAL_CMD_GET_ATT_REQ or #DEVNET_FAL_CMD_SET_ATT_REQ
 * to get or set attribute of the slave*/
#define DN_FAL_GETSET_ATT_REQ_SIZE (sizeof(DN_FAL_SDU_GETSET_ATT_REQ_T)-\
                                                 DN_FAL_SDU_GETSET_ATT_MAX_DATA)
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_GETSET_ATT_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                  /**< Packet Header  */
  DN_FAL_SDU_GETSET_ATT_REQ_T     tData;
}
DN_FAL_PACKET_GETSET_ATT_REQ_T;


#define DN_FAL_GETSET_ATT_CNF_SIZE (sizeof(DN_FAL_SDU_GETSET_ATT_CNF_T)-\
                                                 DN_FAL_SDU_GETSET_ATT_MAX_DATA)
/*! @see DEVNET_FAL_CMD_GET_ATT_CNF, @see DEVNET_FAL_CMD_SET_ATT_CNF */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_GETSET_ATT_CNF_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                 /**< Packet Header   */
  DN_FAL_SDU_GETSET_ATT_CNF_T     tData;
}
DN_FAL_PACKET_GETSET_ATT_CNF_T;

/*! @see DN_FAL_PACKET_STATUS_REQ_T */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_STATUS_REQ_Ttag
{
  TLR_UINT32  uiReturnOptions;
}
DN_FAL_STATUS_REQ_T;

typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_STATUS_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;               /**< Packet Header     */
  DN_FAL_STATUS_REQ_T             tData;               /**< Packet data       */
}
DN_FAL_PACKET_STATUS_REQ_T;

typedef __PACKED_PRE struct __PACKED_POST DN_FAL_STATUS_CNF_Ttag
{
  TLR_UINT8 bV24Status;
}
DN_FAL_STATUS_CNF_T;

typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_STATUS_CNF_Ttag
{
  TLR_PACKET_HEADER_T             tHead;               /**< Packet Header     */
  DN_FAL_STATUS_CNF_T             tData;               /**< Packet data       */
}
DN_FAL_PACKET_STATUS_CNF_T;

/* This packet with #DEVNET_FAL_CMD_ACYC_BTS_REQ has been designed to accomplish
 * acyclic bit-strobing. This is a special method to synchronize the host
 * application and the DeviceNet master device and to plan synchronous actions
 * of master and (single or multiple) slaves.
 */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_BTS_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;               /**< Packet Header     */
  DN_FAL_BTS_REQ_T                tData;               /**< Packet data       */
}
DN_FAL_PACKET_BTS_REQ_T;

/*! @see DEVNET_FAL_CMD_ACYC_BTS_CNF */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_BTS_CNF_Ttag
{
  TLR_PACKET_HEADER_T             tHead;               /**< Packet Header     */
  DN_FAL_BTS_CNF_T                tData;               /**< Packet data       */
}
DN_FAL_PACKET_BTS_CNF_T;

/*!In order to get an overview of all devices physically present in the current
 * network constellation, the #DEVNET_FAL_CMD_LIFELIST_REQ  command can be used
 * Remark: Only DeviceNet devices which have already finished their autobaud
 * detection phase are taken into account. (This might last some seconds.)
 * With the request packet, you need to specify a value for the time how long
 * the DeviceNet Master should wait for the response of the slaves.
*/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_LIFELIST_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;               /**< Packet Header     */
  DN_FAL_LIFELIST_REQ_T           tData;               /**< Packet data       */
}
DN_FAL_PACKET_LIFELIST_REQ_T;

/*! @see DEVNET_FAL_CMD_LIFELIST_CNF*/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_LIFELIST_CNF_Ttag
{
  TLR_PACKET_HEADER_T             tHead;               /**< Packet Header     */
  DN_FAL_LIFELIST_CNF_T           tData;               /**< Packet data       */
}
DN_FAL_PACKET_LIFELIST_CNF_T;

#define DN_FAL_IO_MODE_IND       			       1
#define DN_FAL_MAX_IO_SIZE  256
/****************************************/
/* Shared I/O memory   */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SHARED_IO_MEMORY_Ttag {
  TLR_UINT32  ulDataSta;                                     /**< Data status */
  TLR_UINT32  ulDataLen;                                     /**< Data Length */
  TLR_UINT8   abData[DN_FAL_MAX_IO_SIZE];                    /**< Data        */
}
DN_FAL_SHARED_IO_MEMORY_T;

typedef __PACKED_PRE struct __PACKED_POST DN_FAL_DEV_DIAG_REQ_DATA_Ttag{

  TLR_UINT8      ubDevMacId;/**< MAC ID of the slave.Max 63 */
  TLR_BOOLEAN32  fGetOnly; /**<1 = do not reset corresponding bit in abDv_diag*/
  TLR_UINT8      ubReserved; /**< Reserved */
}
DN_FAL_DEV_DIAG_REQ_DATA_T;

#define DN_FAL_DEV_DIAG_REQ_DATA_SIZE sizeof(DN_FAL_DEV_DIAG_REQ_DATA_T)
/*! @see DEVNET_FAL_CMD_DEV_DIAG_REQ. This packet allows to obtain diagnostic
 * data concerning the device. From which device to take the diagnostic data is
 * decided by the ubDevMacId parameter of the request packet. */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_DEV_DIAG_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;               /**< Packet Header     */

  DN_FAL_DEV_DIAG_REQ_DATA_T      tData;               /**< Packet data       */
}
DN_FAL_PACKET_DEV_DIAG_REQ_T;

typedef __PACKED_PRE struct __PACKED_POST DN_FAL_DEV_DIAG_DATA_Ttag
{
#define DN_FAL_NODE_DIAG_NO_RES            0x80
#define DN_FAL_NODE_DIAG_PRM_FAULT         0x20
#define DN_FAL_NODE_DIAG_CFG_FAULT         0x10
#define DN_FAL_NODE_DIAG_UCMM_SUPPORT      0x08
#define DN_FAL_NODE_DIAG_NOT_CONFIGURED    0x01

  TLR_UINT8  bNodeExtraDiag;                              /**< Extra diagnosis */

  TLR_UINT8  bDevMainState;                                /**< DV_ ... state */
  TLR_UINT8  bOnlineError;
  TLR_UINT8  bGeneralErrorCode;          /**< @see CIP_General_Error_Code ... */
  TLR_UINT8  bAdditionalCode;                     /**< Additional Error Code  */
  TLR_UINT16 usHrtBeatTimeout;         /**< Heartbeat timeout in milliseconds */
}
DN_FAL_DEV_DIAG_DATA_T;

typedef __PACKED_PRE union __PACKED_POST DN_FAL_DEV_DIAG_DATALOAD_Ttag
{
  DN_FAL_DEV_DIAG_DATA_T tDiagData;                            /**< Diagnosis */

  TLR_UINT8              abData[DN_FAL_MAX_DATA_SIZE-6];
                                /*<Size of ubDevMacId+udDataLen+ubDiagType = 6*/
}
DN_FAL_DEV_DIAG_DATALOAD_T;

/*! @see DEVNET_FAL_CMD_DEV_DIAG_CNF */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_DEV_DIAG_CNF_DATA_Ttag{

  TLR_UINT8    ubDevMacId;                        /**< Device MAC ID. Max 64. */

  TLR_UINT32   ulDatLen;                           /**< Data Length           */

  TLR_UINT8    ubDiagType;                         /**< Preserved. Do no used */

  DN_FAL_DEV_DIAG_DATALOAD_T tDataLoad;            /**< Diagnosis             */
}
DN_FAL_DEV_DIAG_CNF_DATA_T;

#define DN_FAL_DEV_DIAG_CNF_DATA_SIZE sizeof(DN_FAL_DEV_DIAG_CNF_DATA_T)

typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_DEV_DIAG_CNF_Ttag
{
  TLR_PACKET_HEADER_T             tHead;

  DN_FAL_DEV_DIAG_CNF_DATA_T      tData;
}
DN_FAL_PACKET_DEV_DIAG_CNF_T;

/** SDU: Service Request and Confirm */
#define DN_FAL_SDU_SERVICE_MAX_DATA  (512)
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_SERVICE_REQ_Ttag
{
  TLR_UINT8  bDevMacId;           /**< Device MAC ID. Max 63                  */

  TLR_UINT16 usSrvDatLen;         /**< Effective Length of Data in abSrvData  */
/*!
00=Reserved \n 01=Get_Attributes_All  \n 02=Set_Attributes_All \n
03=Get_Attribute_List \n 04=Set_Attribute_List \n 05=Reset 06=Start \n 07=Stop
\n 08=Create \n 09=Delete \n 0A=Multiple_Service_Packet
\n 0B=Reserved for future use \n 0D=Apply_Attributes
\n 0E=Get_Attribute_Single \n 0F=Reserved for future use
\n 10=Set_Attribute_Single \n 11=Find_Next_Object_Instance
\n 12-13=Reserved for future use \n 14=ror Response (used by DevNet only)
\n 15=Restore 16=Save \n 17=No Operation(NOP) \n 18=Get_Member \n 19=Set_Member
\n 1A=Insert_Member \n 1B=Remove_Member \n 1C=GroupSync
\n 1D-31 = Reserved for additional Common Services.
@see CIP_Service_Code
*/
  TLR_UINT8  ubServiceCode;

/*! Volume 1 Common Industrial Protocol Specification Chapter 5, Table 5-1.1  */
  TLR_UINT16 usClass;             /**< @see CIP_Class_Code                    */


  TLR_UINT16 usInstance;          /**< See specification of individual object */

  TLR_UINT16 usAttribute;         /**< See specification of individual object */

  TLR_UINT16 usSrvTimeOut;        /**< Service Time Out in milliseconds       */

  TLR_UINT8  abSrvData[DN_FAL_SDU_SERVICE_MAX_DATA];        /**< Service Data */
}DN_FAL_SDU_SERVICE_REQ_T;

typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_SERVICE_CNF_Ttag
{
  TLR_UINT8  bDevMacId;           /**< Device MAC ID. Max 63                  */
  TLR_UINT16 usSrvDatLen;         /**< Effective Length of Data in abSrvData  */
  /*!
  00=Reserved \n 01=Get_Attributes_All  \n 02=Set_Attributes_All \n
  03=Get_Attribute_List \n 04=Set_Attribute_List \n 05=Reset 06=Start \n 07=Stop
  \n 08=Create \n 09=Delete \n 0A=Multiple_Service_Packet
  \n 0B=Reserved for future use \n 0D=Apply_Attributes
  \n 0E=Get_Attribute_Single \n 0F=Reserved for future use
  \n 10=Set_Attribute_Single \n 11=Find_Next_Object_Instance
  \n 12-13=Reserved for future use \n 14=ror Response (used by DevNet only)
  \n 15=Restore 16=Save \n 17=No Operation(NOP) \n 18=Get_Member \n 19=Set_Member
  \n 1A=Insert_Member \n 1B=Remove_Member \n 1C=GroupSync
  \n 1D-31 = Reserved for additional Common Services.
  @see CIP_Service_Code
  */
  TLR_UINT8  ubServiceCode;

  /* Volume 1 Common Industrial Protocol Specification Chapter 5, Table 5-1.1 */
  TLR_UINT16 usClass;             /**< @see CIP_Class_Code                    */

  TLR_UINT16 usInstance;          /**< See specification of individual object */

  TLR_UINT16 usAttribute;         /**< See specification of individual object */

  TLR_UINT8  bGenErr;             /**< @see CIP_General_Error_Code            */

  TLR_UINT8  bAddErr;             /**< Additional error of service inquiry    */

  TLR_UINT8  abSrvData[DN_FAL_SDU_SERVICE_MAX_DATA];
}
DN_FAL_SDU_SERVICE_CNF_T;

#define DN_FAL_SERVICE_REQ_SIZE \
              (sizeof(DN_FAL_PACKET_SERVICE_REQ_T)- sizeof(TLR_PACKET_HEADER_T))

/*!Request sending of service to slave with #DEVNET_FAL_CMD_REMOTE_SERVICE_REQ
 * or #DEVNET_FAL_CMD_LOCAL_SERVICE_REQ
 */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_SERVICE_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                  /**< Packet Header  */

  DN_FAL_SDU_SERVICE_REQ_T        tData;
}
DN_FAL_PACKET_SERVICE_REQ_T;

#define DN_FAL_SERVICE_CNF_SIZE \
               (sizeof(DN_FAL_PACKET_SERVICE_CNF_T)-sizeof(TLR_PACKET_HEADER_T))
/*! @see DEVNET_FAL_CMD_REMOTE_SERVICE_CNF,
 *  @see DEVNET_FAL_CMD_LOCAL_SERVICE_CNF
 */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_SERVICE_CNF_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                 /**< Packet Header   */

  DN_FAL_SDU_SERVICE_CNF_T        tData;
}
DN_FAL_PACKET_SERVICE_CNF_T;

/* SDU: Acyclic IO Poll Request and Confirm */
#define DN_FAL_SDU_ACYC_IO_POLL_MAX_DATA  (512)
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_ACYC_IO_POLL_REQ_Ttag
{
  TLR_UINT8  bDevMacId;           /**< MAC ID of the slave. Max 64            */

  TLR_UINT16 usPollDatLen;        /**< Effective Length of Data in abSrvData  */

  TLR_UINT8  abPollData[DN_FAL_SDU_ACYC_IO_POLL_MAX_DATA];          /**< Data */
}
DN_FAL_SDU_ACYC_IO_POLL_REQ_T;

typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_ACYC_IO_POLL_CNF_Ttag
{
  TLR_UINT8  bDevMacId;           /**< MAC ID of the slave. Max 64            */

  TLR_UINT16 usPollDatLen;        /**< Effective Length of Data in abSrvData  */

  TLR_UINT8  abPollData[DN_FAL_SDU_ACYC_IO_POLL_MAX_DATA];          /**< Data */
}
DN_FAL_SDU_ACYC_IO_POLL_CNF_T;


#define DN_FAL_ACYC_IO_POLL_REQ_SIZE \
         (sizeof(DN_FAL_PACKET_ACYC_IO_POLL_REQ_T)- sizeof(TLR_PACKET_HEADER_T))
/*! Sending of  a poll request to slave at any time using
 * #DEVNET_FAL_CMD_ACYC_POLL_REQ */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_ACYC_IO_POLL_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                  /**< Packet Header  */

  DN_FAL_SDU_ACYC_IO_POLL_REQ_T   tData;                  /**< Data           */
}
DN_FAL_PACKET_ACYC_IO_POLL_REQ_T;


#define DN_FAL_ACYC_IO_POLL_CNF_SIZE \
          (sizeof(DN_FAL_PACKET_ACYC_IO_POLL_CNF_T)-sizeof(TLR_PACKET_HEADER_T))
/*! @see DEVNET_FAL_CMD_ACYC_POLL_REQ */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_ACYC_IO_POLL_CNF_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                 /**< Packet Header   */

  DN_FAL_SDU_ACYC_IO_POLL_CNF_T   tData;                 /**< Data            */
}
DN_FAL_PACKET_ACYC_IO_POLL_CNF_T;

/* SDU: Can Forward Request and Confirm */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_CAN_FWD_REG_REQ_Ttag
{
  TLR_UINT16 usCanId;                                    /**< CAN Identifier  */
  /*Reg Flag                           */
  /* ._.-------.---------------------. */
  /* |x|x|x|x|x|x|x|x|x|x|x|x|x|x|x|x| */
  /* .-._______.---------------------. */
  /*    NotUse.      Identifier        */
}
DN_FAL_SDU_CAN_FWD_REG_REQ_T;

#define DN_FAL_CAN_FWD_REG_REQ_SIZE (sizeof(DN_FAL_SDU_CAN_FWD_REG_REQ_T))
/*! Using with #DEVNET_FAL_CMD_CAN_FWD_REG_REQ to register a CAN forwarding   */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_CAN_FORWARD_REQ_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                  /**< Packet Header  */

  DN_FAL_SDU_CAN_FWD_REG_REQ_T    tData;                  /**< Data           */
}
DN_FAL_PACKET_CAN_FWD_REG_REQ_T;


#define DN_FAL_CAN_FWD_REG_CNF_SIZE (0)
/*! @see DEVNET_FAL_CMD_CAN_FWD_REG_CNF */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_CAN_FORWARD_CNF_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                 /**< Packet Header   */
}
DN_FAL_PACKET_CAN_FWD_REG_CNF_T;


/*! SDU: Can Forward Indication and Response. @see DN_FAL_PACKET_CAN_FWD_IND_T*/
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_SDU_CAN_FRAME_Ttag
{
  /* |x|x|x|x|x|x|x|x|x|x|x|x|x|x|x|x| */
  /* .-------.-.---------------------. */
  /*  Length RTR     Identifier        */

  TLR_UINT16 usCanId;                              /**< CAN ID                */

  TLR_UINT8  ubReserved;                           /**< Reserved, set to 0    */

  TLR_UINT8  abDataLoad[8];                        /**< Dataload              */
}
DN_FAL_SDU_CAN_FRAME_T;

/* PACKET: Service Request/Confirm                                            */
#define DN_FAL_CAN_FWD_IND_SIZE (sizeof(DN_FAL_SDU_CAN_FRAME_T))
/*!Indication with #DEVNET_FAL_CMD_CAN_FWD_IND of CAN-ID that is registered
 * before using #DEVNET_FAL_CMD_CAN_FWD_REG_REQ
 */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_CAN_FWD_IND_Ttag
{
  TLR_PACKET_HEADER_T       tHead;                        /**< Packet Header  */

  DN_FAL_SDU_CAN_FRAME_T    tData;
}
DN_FAL_PACKET_CAN_FWD_IND_T;

#define DN_FAL_CAN_FWD_RES_SIZE (0)
/*! @see DEVNET_FAL_CMD_CAN_FWD_RES */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_CAN_FWD_RES_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                 /**< Packet Header   */
}
DN_FAL_PACKET_CAN_FWD_RES_T;

#define DN_FAL_CAN_DATA_REQ_SIZE (sizeof(DN_FAL_SDU_CAN_FRAME_T))
/*! Sending of CAN frame on bus at anytime using #DEVNET_FAL_CMD_CAN_DATA_REQ */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_CAN_DATA_REQ_Ttag
{
  TLR_PACKET_HEADER_T       tHead;                        /**< Packet Header  */

  DN_FAL_SDU_CAN_FRAME_T    tData;
}
DN_FAL_PACKET_CAN_DATA_REQ_T;

#define DN_FAL_CAN_DATA_CNF_SIZE (0)
/*! @see DEVNET_FAL_CMD_CAN_DATA_CNF */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_CAN_DATA_CNF_Ttag
{
  TLR_PACKET_HEADER_T             tHead;                 /**< Packet Header   */
}
DN_FAL_PACKET_CAN_DATA_CNF_T;


/******************************************************************************/
/*                     DNS_FAL_CMD_LED_STATE_IND Structure                    */
/******************************************************************************/
#define  DNM_LED_TYPE_NS                                                     (1)

#define  DNM_LED_COLR_OFF                                                    (0)
#define  DNM_LED_COLR_GRN                                                    (1)
#define  DNM_LED_COLR_RED                                                    (2)

#define  DNM_LED_MODE_STATIC                                                 (0)
#define  DNM_LED_MODE_FLASH                                                  (1)

typedef __PACKED_PRE struct __PACKED_POST DNM_FAL_LED_STATE_Ttag
{
  TLR_UINT32 ulLedType;                                   /**< NS,            */
  TLR_UINT32 ulLedMode;                                   /**< ON, OFF, FLASH */
  TLR_UINT32 ulLedColor;                                  /**< RED, GRN, OFF  */
}
DNM_FAL_LED_STATE_T;

#define DNM_FAL_LED_STATE_IND_SIZE (sizeof(DNM_FAL_LED_STATE_T))
/*!Indication of state of LEDs using #DEVNET_FAL_CMD_SET_LED_IND              */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_SET_LED_IND_Ttag
{
  TLR_PACKET_HEADER_T tHead;                             /**< Packet Header   */
  DNM_FAL_LED_STATE_T tData;
}
DN_FAL_PACKET_SET_LED_IND_T;

/******************************************************************************/
/*                       DNS_FAL_CMD_LED_STATE_RES Structure                  */
/******************************************************************************/
/*! @see DEVNET_FAL_CMD_SET_LED_IND */
typedef __PACKED_PRE struct __PACKED_POST DN_FAL_PACKET_SET_LED_RES_Ttag
{
  TLR_PACKET_HEADER_T tHead;                             /**< Packet Header   */
}
DN_FAL_PACKET_SET_LED_RES_T;


#ifndef __STRUCT_DNM_REM_DEV_INFO_T__
#define __STRUCT_DNM_REM_DEV_INFO_T__
typedef __PACKED_PRE struct __PACKED_POST DNM_REM_DEV_INFO_Ttag
{
  TLR_UINT8  bMacId;                                     /**< MAC ID          */
  TLR_UINT16 usVendorId;                                 /**< VENDOR ID       */
  TLR_UINT16 usProductCode;                              /**< Product code    */
  TLR_UINT16 usProductType;                              /**< Product type    */
  TLR_UINT8  bMajorRevision;                             /**< Major Revision  */
  TLR_UINT8  bMinorRevision;                             /**< Minor Revision  */
  TLR_UINT8  abProductionName[33];                       /**< Product name    */
}
DNM_REM_DEV_INFO_T;
#endif

#ifndef __STRUCTDESC_DNM_REM_DEV_INFO_T__
#define __STRUCTDESC_DNM_REM_DEV_INFO_T__
static const UINT16 ausSI_DNM_REM_DEV_DESC_T[]=
{
  2056, 0,                                            /*< Struct Id and 0 ??? */
  0, 17, 0,                  /**< 1st element, TLR_UINT8,  0 length not used? */
  1, 18, 0,                  /**< 2nd element, TLR_UINT16, 0 length not used? */
  2, 18, 0,                  /**< 3rd element, TLR_UINT16, 0 length not used? */
  3, 18, 0,                  /**< 4th element, TLR_UINT16, 0 length not used? */
  4, 17, 0,                  /**< 5th element, TLR_UINT8,  0 length not used? */
  5, 17, 0,                  /**< 6th element, TLR_UINT8,  0 length not used? */
  6, 8209, 33,               /**< 7th element, array of TLR_UINT8, length 33  */
};
#endif

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(DEVNET_FAL_PUBLIC)
#endif

TLR_VOID DnFal_ConsumeUpdate      (TLR_VOID FAR* ptRsc,
                                   TLR_UINT32 ulDataSta,
                                   TLR_UINT8 *pabConsData,
                                   TLR_UINT32 ulConsLen);

TLR_RESULT DnFal_UcmmReqRx        (TLR_VOID FAR* pvRsc);
TLR_RESULT DnFal_OpenUcmmReqRx    (TLR_VOID FAR* pvRsc);
TLR_RESULT DnFal_GenUcmmCloseReqRx(TLR_VOID FAR* pvRsc);
TLR_RESULT DnFal_GenUcmmCloseRsp  (TLR_VOID FAR* pvRsc);
TLR_RESULT DnFal_GenUcmmErrorRsp  (TLR_VOID FAR* pvRsc);
TLR_RESULT DnFal_GenUcmmOpenRsp   (TLR_VOID FAR* pvRsc);
/******************************************************************************/
#endif /* #ifndef __DEVNET_FAL_PUBLIC_H__ */
